/*
 * Decompiled with CFR 0.152.
 */
package org.tc33.jheatchart;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.FileImageOutputStream;

public class HeatChart {
    public static final double SCALE_LOGARITHMIC = 0.3;
    public static final double SCALE_LINEAR = 1.0;
    public static final double SCALE_EXPONENTIAL = 3.0;
    private double[][] zValues;
    private Object[] xValues;
    private Object[] yValues;
    private boolean xValuesHorizontal;
    private boolean yValuesHorizontal;
    private Dimension cellSize;
    private Dimension chartSize;
    private int margin;
    private Color backgroundColour;
    private String title;
    private Font titleFont;
    private Color titleColour;
    private Dimension titleSize;
    private int titleAscent;
    private int axisThickness;
    private Color axisColour;
    private Font axisLabelsFont;
    private Color axisLabelColour;
    private String xAxisLabel;
    private String yAxisLabel;
    private Color axisValuesColour;
    private Font axisValuesFont;
    private int xAxisValuesFrequency;
    private int yAxisValuesFrequency;
    private boolean showXAxisValues;
    private boolean showYAxisValues;
    private int xAxisValuesHeight;
    private int xAxisValuesWidthMax;
    private int yAxisValuesHeight;
    private int yAxisValuesAscent;
    private int yAxisValuesWidthMax;
    private Dimension xAxisLabelSize;
    private int xAxisLabelDescent;
    private Dimension yAxisLabelSize;
    private int yAxisLabelAscent;
    private Color highValueColour;
    private Color lowValueColour;
    private int colourValueDistance;
    private double lowValue;
    private double highValue;
    private Point heatMapTL;
    private Point heatMapBR;
    private Point heatMapC;
    private Dimension heatMapSize;
    private double colourScale;

    public HeatChart(double[][] dArray) {
        this(dArray, HeatChart.min(dArray), HeatChart.max(dArray));
    }

    public HeatChart(double[][] dArray, double d, double d2) {
        this.zValues = dArray;
        this.lowValue = d;
        this.highValue = d2;
        this.setXValues(0.0, 1.0);
        this.setYValues(0.0, 1.0);
        this.cellSize = new Dimension(20, 20);
        this.margin = 20;
        this.backgroundColour = Color.WHITE;
        this.title = null;
        this.titleFont = new Font("Sans-Serif", 1, 16);
        this.titleColour = Color.BLACK;
        this.xAxisLabel = null;
        this.yAxisLabel = null;
        this.axisThickness = 2;
        this.axisColour = Color.BLACK;
        this.axisLabelsFont = new Font("Sans-Serif", 0, 12);
        this.axisLabelColour = Color.BLACK;
        this.axisValuesColour = Color.BLACK;
        this.axisValuesFont = new Font("Sans-Serif", 0, 10);
        this.xAxisValuesFrequency = 1;
        this.xAxisValuesHeight = 0;
        this.xValuesHorizontal = false;
        this.showXAxisValues = true;
        this.showYAxisValues = true;
        this.yAxisValuesFrequency = 1;
        this.yAxisValuesHeight = 0;
        this.yValuesHorizontal = true;
        this.highValueColour = Color.BLACK;
        this.lowValueColour = Color.WHITE;
        this.colourScale = 1.0;
        this.updateColourDistance();
    }

    public double getLowValue() {
        return this.lowValue;
    }

    public double getHighValue() {
        return this.highValue;
    }

    public double[][] getZValues() {
        return this.zValues;
    }

    public void setZValues(double[][] dArray) {
        this.setZValues(dArray, HeatChart.min(dArray), HeatChart.max(dArray));
    }

    public void setZValues(double[][] dArray, double d, double d2) {
        this.zValues = dArray;
        this.lowValue = d;
        this.highValue = d2;
    }

    public void setXValues(double d, double d2) {
        this.xValues = new Object[this.zValues[0].length];
        for (int i = 0; i < this.zValues[0].length; ++i) {
            this.xValues[i] = d + (double)i * d2;
        }
    }

    public void setXValues(Object[] objectArray) {
        this.xValues = objectArray;
    }

    public void setYValues(double d, double d2) {
        this.yValues = new Object[this.zValues.length];
        for (int i = 0; i < this.zValues.length; ++i) {
            this.yValues[i] = d + (double)i * d2;
        }
    }

    public void setYValues(Object[] objectArray) {
        this.yValues = objectArray;
    }

    public Object[] getXValues() {
        return this.xValues;
    }

    public Object[] getYValues() {
        return this.yValues;
    }

    public void setXValuesHorizontal(boolean bl) {
        this.xValuesHorizontal = bl;
    }

    public boolean isXValuesHorizontal() {
        return this.xValuesHorizontal;
    }

    public void setYValuesHorizontal(boolean bl) {
        this.yValuesHorizontal = bl;
    }

    public boolean isYValuesHorizontal() {
        return this.yValuesHorizontal;
    }

    @Deprecated
    public void setCellWidth(int n) {
        this.setCellSize(new Dimension(n, this.cellSize.height));
    }

    @Deprecated
    public int getCellWidth() {
        return this.cellSize.width;
    }

    @Deprecated
    public void setCellHeight(int n) {
        this.setCellSize(new Dimension(this.cellSize.width, n));
    }

    @Deprecated
    public int getCellHeight() {
        return this.cellSize.height;
    }

    public void setCellSize(Dimension dimension) {
        this.cellSize = dimension;
    }

    public Dimension getCellSize() {
        return this.cellSize;
    }

    @Deprecated
    public int getChartWidth() {
        return this.chartSize.width;
    }

    @Deprecated
    public int getChartHeight() {
        return this.chartSize.height;
    }

    public Dimension getChartSize() {
        return this.chartSize;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public String getXAxisLabel() {
        return this.xAxisLabel;
    }

    public void setXAxisLabel(String string) {
        this.xAxisLabel = string;
    }

    public String getYAxisLabel() {
        return this.yAxisLabel;
    }

    public void setYAxisLabel(String string) {
        this.yAxisLabel = string;
    }

    public int getChartMargin() {
        return this.margin;
    }

    public void setChartMargin(int n) {
        this.margin = n;
    }

    public Color getBackgroundColour() {
        return this.backgroundColour;
    }

    public void setBackgroundColour(Color color) {
        if (color == null) {
            color = Color.WHITE;
        }
        this.backgroundColour = color;
    }

    public Font getTitleFont() {
        return this.titleFont;
    }

    public void setTitleFont(Font font) {
        this.titleFont = font;
    }

    public Color getTitleColour() {
        return this.titleColour;
    }

    public void setTitleColour(Color color) {
        this.titleColour = color;
    }

    public int getAxisThickness() {
        return this.axisThickness;
    }

    public void setAxisThickness(int n) {
        this.axisThickness = n;
    }

    public Color getAxisColour() {
        return this.axisColour;
    }

    public void setAxisColour(Color color) {
        this.axisColour = color;
    }

    public Font getAxisLabelsFont() {
        return this.axisLabelsFont;
    }

    public void setAxisLabelsFont(Font font) {
        this.axisLabelsFont = font;
    }

    public Color getAxisLabelColour() {
        return this.axisLabelColour;
    }

    public void setAxisLabelColour(Color color) {
        this.axisLabelColour = color;
    }

    public Font getAxisValuesFont() {
        return this.axisValuesFont;
    }

    public void setAxisValuesFont(Font font) {
        this.axisValuesFont = font;
    }

    public Color getAxisValuesColour() {
        return this.axisValuesColour;
    }

    public void setAxisValuesColour(Color color) {
        this.axisValuesColour = color;
    }

    public int getXAxisValuesFrequency() {
        return this.xAxisValuesFrequency;
    }

    public void setXAxisValuesFrequency(int n) {
        this.xAxisValuesFrequency = n;
    }

    public int getYAxisValuesFrequency() {
        return this.yAxisValuesFrequency;
    }

    public void setYAxisValuesFrequency(int n) {
        this.yAxisValuesFrequency = n;
    }

    public boolean isShowXAxisValues() {
        return this.showXAxisValues;
    }

    public void setShowXAxisValues(boolean bl) {
        this.showXAxisValues = bl;
    }

    public boolean isShowYAxisValues() {
        return this.showYAxisValues;
    }

    public void setShowYAxisValues(boolean bl) {
        this.showYAxisValues = bl;
    }

    public Color getHighValueColour() {
        return this.highValueColour;
    }

    public void setHighValueColour(Color color) {
        this.highValueColour = color;
        this.updateColourDistance();
    }

    public Color getLowValueColour() {
        return this.lowValueColour;
    }

    public void setLowValueColour(Color color) {
        this.lowValueColour = color;
        this.updateColourDistance();
    }

    public double getColourScale() {
        return this.colourScale;
    }

    public void setColourScale(double d) {
        this.colourScale = d;
    }

    private void updateColourDistance() {
        int n = this.lowValueColour.getRed();
        int n2 = this.lowValueColour.getGreen();
        int n3 = this.lowValueColour.getBlue();
        int n4 = this.highValueColour.getRed();
        int n5 = this.highValueColour.getGreen();
        int n6 = this.highValueColour.getBlue();
        this.colourValueDistance = Math.abs(n - n4);
        this.colourValueDistance += Math.abs(n2 - n5);
        this.colourValueDistance += Math.abs(n3 - n6);
    }

    public void saveToFile(File file) throws IOException {
        String string = file.getName();
        int n = string.lastIndexOf(46);
        if (n < 0) {
            throw new IOException("Illegal filename, no extension used.");
        }
        String string2 = string.substring(n + 1);
        if (string2.toLowerCase().equals("jpg") || string2.toLowerCase().equals("jpeg")) {
            BufferedImage bufferedImage = (BufferedImage)this.getChartImage(false);
            this.saveGraphicJpeg(bufferedImage, file, 1.0f);
        } else {
            BufferedImage bufferedImage = (BufferedImage)this.getChartImage(true);
            ImageIO.write((RenderedImage)bufferedImage, string2, file);
        }
    }

    private void saveGraphicJpeg(BufferedImage bufferedImage, File file, float f) throws IOException {
        Iterator<ImageWriter> iterator = ImageIO.getImageWritersByFormatName("jpeg");
        ImageWriter imageWriter = iterator.next();
        ImageWriteParam imageWriteParam = imageWriter.getDefaultWriteParam();
        imageWriteParam.setCompressionMode(2);
        imageWriteParam.setCompressionQuality(f);
        FileImageOutputStream fileImageOutputStream = new FileImageOutputStream(file);
        imageWriter.setOutput(fileImageOutputStream);
        IIOImage iIOImage = new IIOImage(bufferedImage, null, null);
        imageWriter.write(null, iIOImage, imageWriteParam);
        imageWriter.dispose();
    }

    public Image getChartImage(boolean bl) {
        this.measureComponents();
        this.updateCoordinates();
        int n = bl ? 6 : 5;
        BufferedImage bufferedImage = new BufferedImage(this.chartSize.width, this.chartSize.height, n);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(this.backgroundColour);
        graphics2D.fillRect(0, 0, this.chartSize.width, this.chartSize.height);
        this.drawTitle(graphics2D);
        this.drawHeatMap(graphics2D, this.zValues);
        this.drawXLabel(graphics2D);
        this.drawYLabel(graphics2D);
        this.drawAxisBars(graphics2D);
        this.drawXValues(graphics2D);
        this.drawYValues(graphics2D);
        return bufferedImage;
    }

    public Image getChartImage() {
        return this.getChartImage(false);
    }

    public void getChartGraphics(Graphics2D graphics2D) {
        this.measureComponents();
        this.updateCoordinates();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(this.backgroundColour);
        graphics2D.fillRect(0, 0, this.chartSize.width, this.chartSize.height);
        this.drawTitle(graphics2D);
        this.drawHeatMap(graphics2D, this.zValues);
        this.drawXLabel(graphics2D);
        this.drawYLabel(graphics2D);
        this.drawAxisBars(graphics2D);
        this.drawXValues(graphics2D);
        this.drawYValues(graphics2D);
    }

    private void measureComponents() {
        int n;
        FontMetrics fontMetrics;
        BufferedImage bufferedImage = new BufferedImage(1, 1, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        if (this.title != null) {
            graphics2D.setFont(this.titleFont);
            fontMetrics = graphics2D.getFontMetrics();
            this.titleSize = new Dimension(fontMetrics.stringWidth(this.title), fontMetrics.getHeight());
            this.titleAscent = fontMetrics.getAscent();
        } else {
            this.titleSize = new Dimension(0, 0);
        }
        if (this.xAxisLabel != null) {
            graphics2D.setFont(this.axisLabelsFont);
            fontMetrics = graphics2D.getFontMetrics();
            this.xAxisLabelSize = new Dimension(fontMetrics.stringWidth(this.xAxisLabel), fontMetrics.getHeight());
            this.xAxisLabelDescent = fontMetrics.getDescent();
        } else {
            this.xAxisLabelSize = new Dimension(0, 0);
        }
        if (this.yAxisLabel != null) {
            graphics2D.setFont(this.axisLabelsFont);
            fontMetrics = graphics2D.getFontMetrics();
            this.yAxisLabelSize = new Dimension(fontMetrics.stringWidth(this.yAxisLabel), fontMetrics.getHeight());
            this.yAxisLabelAscent = fontMetrics.getAscent();
        } else {
            this.yAxisLabelSize = new Dimension(0, 0);
        }
        if (this.showXAxisValues) {
            graphics2D.setFont(this.axisValuesFont);
            fontMetrics = graphics2D.getFontMetrics();
            this.xAxisValuesHeight = fontMetrics.getHeight();
            this.xAxisValuesWidthMax = 0;
            for (Object object : this.xValues) {
                n = fontMetrics.stringWidth(object.toString());
                if (n <= this.xAxisValuesWidthMax) continue;
                this.xAxisValuesWidthMax = n;
            }
        } else {
            this.xAxisValuesHeight = 0;
        }
        if (this.showYAxisValues) {
            graphics2D.setFont(this.axisValuesFont);
            fontMetrics = graphics2D.getFontMetrics();
            this.yAxisValuesHeight = fontMetrics.getHeight();
            this.yAxisValuesAscent = fontMetrics.getAscent();
            this.yAxisValuesWidthMax = 0;
            for (Object object : this.yValues) {
                n = fontMetrics.stringWidth(object.toString());
                if (n <= this.yAxisValuesWidthMax) continue;
                this.yAxisValuesWidthMax = n;
            }
        } else {
            this.yAxisValuesHeight = 0;
        }
        int n2 = this.zValues[0].length * this.cellSize.width;
        int n3 = this.zValues.length * this.cellSize.height;
        this.heatMapSize = new Dimension(n2, n3);
        int n4 = 0;
        n4 = this.yValuesHorizontal ? this.yAxisValuesWidthMax : this.yAxisValuesHeight;
        int n5 = 0;
        n5 = this.xValuesHorizontal ? this.xAxisValuesHeight : this.xAxisValuesWidthMax;
        int n6 = n2 + 2 * this.margin + this.yAxisLabelSize.height + n4 + this.axisThickness;
        n = n3 + 2 * this.margin + this.xAxisLabelSize.height + n5 + this.titleSize.height + this.axisThickness;
        this.chartSize = new Dimension(n6, n);
    }

    private void updateCoordinates() {
        int n = this.margin + this.axisThickness + this.yAxisLabelSize.height;
        int n2 = this.yValuesHorizontal ? this.yAxisValuesWidthMax : this.yAxisValuesHeight;
        int n3 = this.titleSize.height + this.margin;
        this.heatMapTL = new Point(n += n2, n3);
        n = this.heatMapTL.x + this.heatMapSize.width;
        n3 = this.heatMapTL.y + this.heatMapSize.height;
        this.heatMapBR = new Point(n, n3);
        n = this.heatMapTL.x + this.heatMapSize.width / 2;
        n3 = this.heatMapTL.y + this.heatMapSize.height / 2;
        this.heatMapC = new Point(n, n3);
    }

    private void drawTitle(Graphics2D graphics2D) {
        if (this.title != null) {
            int n = this.margin / 2 + this.titleAscent;
            int n2 = this.chartSize.width / 2 - this.titleSize.width / 2;
            graphics2D.setFont(this.titleFont);
            graphics2D.setColor(this.titleColour);
            graphics2D.drawString(this.title, n2, n);
        }
    }

    private void drawHeatMap(Graphics2D graphics2D, double[][] dArray) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        BufferedImage bufferedImage = new BufferedImage(this.heatMapSize.width, this.heatMapSize.height, 2);
        Graphics2D graphics2D2 = bufferedImage.createGraphics();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                graphics2D2.setColor(this.getCellColour(dArray[j][i], this.lowValue, this.highValue));
                int n3 = i * this.cellSize.width;
                int n4 = j * this.cellSize.height;
                graphics2D2.fillRect(n3, n4, this.cellSize.width, this.cellSize.height);
            }
        }
        graphics2D.drawImage(bufferedImage, this.heatMapTL.x, this.heatMapTL.y, this.heatMapSize.width, this.heatMapSize.height, null);
    }

    private void drawXLabel(Graphics2D graphics2D) {
        if (this.xAxisLabel != null) {
            int n = this.chartSize.height - this.margin / 2 - this.xAxisLabelDescent;
            int n2 = this.heatMapC.x - this.xAxisLabelSize.width / 2;
            graphics2D.setFont(this.axisLabelsFont);
            graphics2D.setColor(this.axisLabelColour);
            graphics2D.drawString(this.xAxisLabel, n2, n);
        }
    }

    private void drawYLabel(Graphics2D graphics2D) {
        if (this.yAxisLabel != null) {
            int n = this.heatMapC.y + this.yAxisLabelSize.width / 2;
            int n2 = this.margin / 2 + this.yAxisLabelAscent;
            graphics2D.setFont(this.axisLabelsFont);
            graphics2D.setColor(this.axisLabelColour);
            AffineTransform affineTransform = graphics2D.getTransform();
            AffineTransform affineTransform2 = (AffineTransform)affineTransform.clone();
            affineTransform.rotate(Math.toRadians(270.0), n2, n);
            graphics2D.setTransform(affineTransform);
            graphics2D.drawString(this.yAxisLabel, n2, n);
            graphics2D.setTransform(affineTransform2);
        }
    }

    private void drawAxisBars(Graphics2D graphics2D) {
        if (this.axisThickness > 0) {
            graphics2D.setColor(this.axisColour);
            int n = this.heatMapTL.x - this.axisThickness;
            int n2 = this.heatMapBR.y;
            int n3 = this.heatMapSize.width + this.axisThickness;
            int n4 = this.axisThickness;
            graphics2D.fillRect(n, n2, n3, n4);
            n = this.heatMapTL.x - this.axisThickness;
            n2 = this.heatMapTL.y;
            n3 = this.axisThickness;
            n4 = this.heatMapSize.height;
            graphics2D.fillRect(n, n2, n3, n4);
        }
    }

    private void drawXValues(Graphics2D graphics2D) {
        if (!this.showXAxisValues) {
            return;
        }
        graphics2D.setColor(this.axisValuesColour);
        for (int i = 0; i < this.xValues.length; ++i) {
            int n;
            int n2;
            if (i % this.xAxisValuesFrequency != 0) continue;
            String string = this.xValues[i].toString();
            graphics2D.setFont(this.axisValuesFont);
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            int n3 = fontMetrics.stringWidth(string);
            if (this.xValuesHorizontal) {
                n2 = i * this.cellSize.width + (this.cellSize.width / 2 - n3 / 2);
                n = this.heatMapBR.y + fontMetrics.getAscent() + 1;
                graphics2D.drawString(string, n2 += this.heatMapTL.x, n);
                continue;
            }
            n2 = this.heatMapTL.x + i * this.cellSize.width + (this.cellSize.width / 2 + this.xAxisValuesHeight / 2);
            n = this.heatMapBR.y + this.axisThickness + n3;
            AffineTransform affineTransform = graphics2D.getTransform();
            AffineTransform affineTransform2 = (AffineTransform)affineTransform.clone();
            affineTransform.rotate(Math.toRadians(270.0), n2, n);
            graphics2D.setTransform(affineTransform);
            graphics2D.drawString(string, n2, n);
            graphics2D.setTransform(affineTransform2);
        }
    }

    private void drawYValues(Graphics2D graphics2D) {
        if (!this.showYAxisValues) {
            return;
        }
        graphics2D.setColor(this.axisValuesColour);
        for (int i = 0; i < this.yValues.length; ++i) {
            int n;
            int n2;
            if (i % this.yAxisValuesFrequency != 0) continue;
            String string = this.yValues[i].toString();
            graphics2D.setFont(this.axisValuesFont);
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            int n3 = fontMetrics.stringWidth(string);
            if (this.yValuesHorizontal) {
                n2 = this.margin + this.yAxisLabelSize.height + (this.yAxisValuesWidthMax - n3);
                n = this.heatMapTL.y + i * this.cellSize.height + this.cellSize.height / 2 + this.yAxisValuesAscent / 2;
                graphics2D.drawString(string, n2, n);
                continue;
            }
            n2 = this.margin + this.yAxisLabelSize.height + this.yAxisValuesAscent;
            n = this.heatMapTL.y + i * this.cellSize.height + this.cellSize.height / 2 + n3 / 2;
            AffineTransform affineTransform = graphics2D.getTransform();
            AffineTransform affineTransform2 = (AffineTransform)affineTransform.clone();
            affineTransform.rotate(Math.toRadians(270.0), n2, n);
            graphics2D.setTransform(affineTransform);
            graphics2D.drawString(string, n2, n);
            graphics2D.setTransform(affineTransform2);
        }
    }

    private Color getCellColour(double d, double d2, double d3) {
        double d4 = d3 - d2;
        double d5 = d - d2;
        double d6 = d5 / d4;
        int n = this.getColourPosition(d6);
        int n2 = this.lowValueColour.getRed();
        int n3 = this.lowValueColour.getGreen();
        int n4 = this.lowValueColour.getBlue();
        for (int i = 0; i < n; ++i) {
            int n5 = n2 - this.highValueColour.getRed();
            int n6 = n3 - this.highValueColour.getGreen();
            int n7 = n4 - this.highValueColour.getBlue();
            if (Math.abs(n5) >= Math.abs(n6) && Math.abs(n5) >= Math.abs(n7)) {
                n2 = this.changeColourValue(n2, n5);
                continue;
            }
            if (Math.abs(n6) >= Math.abs(n7)) {
                n3 = this.changeColourValue(n3, n6);
                continue;
            }
            n4 = this.changeColourValue(n4, n7);
        }
        return new Color(n2, n3, n4);
    }

    private int getColourPosition(double d) {
        return (int)Math.round((double)this.colourValueDistance * Math.pow(d, this.colourScale));
    }

    private int changeColourValue(int n, int n2) {
        if (n2 < 0) {
            return n + 1;
        }
        if (n2 > 0) {
            return n - 1;
        }
        return n;
    }

    public static double max(double[][] dArray) {
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[i].length; ++j) {
                d = dArray[i][j] > d ? dArray[i][j] : d;
            }
        }
        return d;
    }

    public static double min(double[][] dArray) {
        double d = Double.MAX_VALUE;
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[i].length; ++j) {
                d = dArray[i][j] < d ? dArray[i][j] : d;
            }
        }
        return d;
    }
}

