/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.tribble.index.interval;

import htsjdk.tribble.index.Block;

public class Interval
implements Comparable {
    final int start;
    final int end;
    private Block block;

    public Interval(int start, int end) {
        assert (start <= end);
        this.start = start;
        this.end = end;
    }

    public Interval(int start, int end, Block block) {
        assert (start <= end);
        this.start = start;
        this.end = end;
        this.block = block;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (this.getClass().equals(other.getClass())) {
            Interval otherInterval = (Interval)other;
            return this.start == otherInterval.start && this.end == otherInterval.end;
        }
        return false;
    }

    public int hashCode() {
        return this.start;
    }

    public int compareTo(Object o) {
        Interval other = (Interval)o;
        if (this.start < other.start) {
            return -1;
        }
        if (this.start > other.start) {
            return 1;
        }
        if (this.end < other.end) {
            return -1;
        }
        if (this.end > other.end) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return "Interval[" + this.start + ", " + this.end + "]";
    }

    public boolean overlaps(Interval other) {
        return this.start <= other.end && other.start <= this.end;
    }

    public Block getBlock() {
        return this.block;
    }
}

