/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils.bytecode;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.biojava.utils.bytecode.BranchFixup;
import org.biojava.utils.bytecode.CodeClass;
import org.biojava.utils.bytecode.CodeContext;
import org.biojava.utils.bytecode.CodeException;
import org.biojava.utils.bytecode.CodeMethod;
import org.biojava.utils.bytecode.ConstantPool;
import org.biojava.utils.bytecode.ExceptionMemento;
import org.biojava.utils.bytecode.Label;
import org.biojava.utils.bytecode.LocalVariable;
import org.biojava.utils.bytecode.OutstandingReference;
import org.biojava.utils.bytecode.ParentContext;
import org.biojava.utils.bytecode.SimpleReference;

class ChildContext
implements CodeContext,
ParentContext {
    ParentContext ourParent;
    private List outstandingRefs = new ArrayList();
    private Map markedLabels = new HashMap();
    private Map localVariables = new HashMap();
    private int usedLocals;

    ChildContext(ParentContext parentContext) {
        this.ourParent = parentContext;
        this.usedLocals = this.ourParent.getUsedLocals();
    }

    public CodeClass getCodeClass() {
        return this.ourParent.getCodeClass();
    }

    public CodeMethod getCodeMethod() {
        return this.ourParent.getCodeMethod();
    }

    public ConstantPool getConstants() {
        return this.ourParent.getConstants();
    }

    public void writeByte(byte by) throws CodeException {
        this.ourParent.writeByte(by);
    }

    public void writeShort(int n) throws CodeException {
        this.ourParent.writeShort(n);
    }

    public void writeShortAt(int n, int n2) {
        this.ourParent.writeShortAt(n, n2);
    }

    public void markLabel(Label label) throws CodeException {
        if (this.markedLabels.containsKey(label)) {
            throw new CodeException("Attempt to duplicate marked label");
        }
        this.markedLabels.put(label, new Integer(this.getOffset()));
    }

    public void promoteOutstandingReference(OutstandingReference outstandingReference) {
        this.outstandingRefs.add(outstandingReference);
    }

    public void writeLabel(Label label) throws CodeException {
        this.outstandingRefs.add(new BranchFixup(label, this.getOffset(), this));
        this.writeShort(0);
    }

    public int getOffset() {
        return this.ourParent.getOffset();
    }

    public void open() {
    }

    public void close() throws CodeException {
        ListIterator listIterator = this.outstandingRefs.listIterator();
        while (listIterator.hasNext()) {
            OutstandingReference outstandingReference = (OutstandingReference)listIterator.next();
            Integer n = (Integer)this.markedLabels.get(outstandingReference.getLabel());
            if (n != null) {
                outstandingReference.resolve(n);
                continue;
            }
            this.ourParent.promoteOutstandingReference(outstandingReference);
        }
    }

    public CodeContext subContext() {
        return new ChildContext(this);
    }

    public int resolveLocal(LocalVariable localVariable) {
        Integer n = (Integer)this.localVariables.get(localVariable);
        if (n != null) {
            return n;
        }
        int n2 = this.ourParent.resolveLocalNoCreate(localVariable);
        if (n2 < 0) {
            n2 = this.usedLocals;
            this.usedLocals += localVariable.needSlots();
            this.setMaxLocals(this.usedLocals);
        }
        this.localVariables.put(localVariable, new Integer(n2));
        return n2;
    }

    public int resolveLocalNoCreate(LocalVariable localVariable) {
        Integer n = (Integer)this.localVariables.get(localVariable);
        if (n != null) {
            return n;
        }
        return this.ourParent.resolveLocalNoCreate(localVariable);
    }

    public int getUsedLocals() {
        return this.usedLocals;
    }

    public void setMaxLocals(int n) {
        this.ourParent.setMaxLocals(n);
    }

    public void addExceptionTableEntry(Label label, Label label2, CodeClass codeClass, Label label3) {
        SimpleReference simpleReference = new SimpleReference(label);
        SimpleReference simpleReference2 = new SimpleReference(label2);
        SimpleReference simpleReference3 = new SimpleReference(label3);
        this.outstandingRefs.add(simpleReference);
        this.outstandingRefs.add(simpleReference2);
        this.outstandingRefs.add(simpleReference3);
        this.addExceptionTableEntry(new ExceptionMemento(simpleReference, simpleReference2, codeClass, simpleReference3));
    }

    public void addExceptionTableEntry(ExceptionMemento exceptionMemento) {
        this.ourParent.addExceptionTableEntry(exceptionMemento);
    }
}

