/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils;

public class ParserException
extends Exception {
    private String locator = null;
    private int lineNumber = -1;
    private int character = -1;
    private String line = null;

    public ParserException(String string) {
        super(string);
    }

    public ParserException(String string, String string2) {
        super(string);
        this.locator = string2;
    }

    public ParserException(String string, String string2, int n) {
        super(string);
        this.locator = string2;
        this.lineNumber = n;
    }

    public ParserException(String string, String string2, int n, String string3) {
        super(string);
        this.locator = string2;
        this.lineNumber = n;
        this.line = string3;
    }

    public ParserException(String string, String string2, int n, String string3, int n2) {
        super(string);
        this.locator = string2;
        this.lineNumber = n;
        this.character = n2;
        this.line = string3;
    }

    public int getCharacterOffset() {
        return this.character;
    }

    public String getLine() {
        return this.line;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getLocator() {
        return this.locator;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        if (this.locator != null) {
            stringBuffer.append('\n');
            stringBuffer.append("Parsing location: ");
            stringBuffer.append(this.locator);
        }
        if (this.lineNumber >= 0) {
            stringBuffer.append('\n');
            stringBuffer.append("Parsing line: ");
            stringBuffer.append(this.lineNumber);
        }
        if (this.line != null) {
            stringBuffer.append('\n');
            stringBuffer.append(this.line);
            if (this.character >= 0) {
                stringBuffer.append('\n');
                int n = 0;
                while (n < this.character) {
                    stringBuffer.append(' ');
                    ++n;
                }
                stringBuffer.append('^');
            }
        }
        stringBuffer.append('\n');
        return stringBuffer.toString();
    }
}

