/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.stats.svm;

import java.util.Iterator;
import java.util.Set;
import org.biojava.stats.svm.SVMClassifierModel;
import org.biojava.stats.svm.SVMKernel;
import org.biojava.stats.svm.SVMTarget;
import org.biojava.stats.svm.SimpleSVMClassifierModel;
import org.biojava.stats.svm.TrainingContext;
import org.biojava.stats.svm.TrainingEvent;
import org.biojava.stats.svm.TrainingListener;

public class SMOTrainer {
    private double _C = 1000.0;
    private double _epsilon = 1.0E-6;

    private int examineExample(SMOTrainingContext sMOTrainingContext, int n) {
        double d = sMOTrainingContext.getTarget(n);
        double d2 = sMOTrainingContext.getAlpha(n);
        double d3 = sMOTrainingContext.getError(n);
        double d4 = d3 * d;
        double d5 = sMOTrainingContext.getEpsilon();
        double d6 = sMOTrainingContext.getC();
        if (d4 < -d5 && d2 < d6 || d4 > d5 && d2 > 0.0) {
            int n2;
            int n3 = -1;
            double d7 = 0.0;
            int n4 = 0;
            while (n4 < sMOTrainingContext.size()) {
                double d8;
                if (!sMOTrainingContext.isBound(sMOTrainingContext.getAlpha(n4)) && (d8 = Math.abs(sMOTrainingContext.getError(n4) - d3)) > d7) {
                    d7 = d8;
                    n3 = n4;
                }
                ++n4;
            }
            if (n3 >= 0 && this.takeStep(sMOTrainingContext, n3, n)) {
                return 1;
            }
            int n5 = (int)Math.floor(Math.random() * (double)sMOTrainingContext.size());
            int n6 = 0;
            while (n6 < sMOTrainingContext.size()) {
                n2 = (n6 + n5) % sMOTrainingContext.size();
                if (!sMOTrainingContext.isBound(sMOTrainingContext.getAlpha(n2)) && this.takeStep(sMOTrainingContext, n2, n)) {
                    return 1;
                }
                ++n6;
            }
            n2 = 0;
            while (n2 < sMOTrainingContext.size()) {
                int n7 = (n2 + n5) % sMOTrainingContext.size();
                if (sMOTrainingContext.isBound(sMOTrainingContext.getAlpha(n7)) && this.takeStep(sMOTrainingContext, n7, n)) {
                    return 1;
                }
                ++n2;
            }
        }
        return 0;
    }

    public double getC() {
        return this._C;
    }

    public double getEpsilon() {
        return this._epsilon;
    }

    public void setC(double d) {
        this._C = d;
    }

    public void setEpsilon(double d) {
        this._epsilon = d;
    }

    private boolean takeStep(SMOTrainingContext sMOTrainingContext, int n, int n2) {
        double d;
        double d2;
        double d3;
        if (n == n2) {
            return false;
        }
        double d4 = sMOTrainingContext.getTarget(n);
        double d5 = sMOTrainingContext.getTarget(n2);
        double d6 = sMOTrainingContext.getAlpha(n);
        double d7 = sMOTrainingContext.getAlpha(n2);
        double d8 = sMOTrainingContext.getError(n);
        double d9 = sMOTrainingContext.getError(n2);
        double d10 = d4 * d5;
        double d11 = sMOTrainingContext.getC();
        double d12 = sMOTrainingContext.getEpsilon();
        if (d5 != d4) {
            d3 = Math.max(0.0, d7 - d6);
            d2 = Math.min(d11, d11 + d7 - d6);
        } else {
            d3 = Math.max(0.0, d6 + d7 - d11);
            d2 = Math.min(d11, d6 + d7);
        }
        if (d3 == d2) {
            return false;
        }
        double d13 = sMOTrainingContext.getKernelValue(n, n);
        double d14 = sMOTrainingContext.getKernelValue(n, n2);
        double d15 = sMOTrainingContext.getKernelValue(n2, n2);
        double d16 = 2.0 * d14 - d13 - d15;
        double d17 = 0.0;
        double d18 = 0.0;
        if (d16 > 0.0 && d16 < d12) {
            d16 = 0.0;
        }
        if (d16 < 0.0) {
            d18 = d7 - d5 * (d8 - d9) / d16;
            if (d18 < d3) {
                d18 = d3;
            } else if (d18 > d2) {
                d18 = d2;
            }
        } else {
            return false;
        }
        d17 = d6 + d10 * (d7 - d18);
        if (Math.abs(d17 - d6) < d12 * (d17 + d6 + 1.0 + d12)) {
            return false;
        }
        double d19 = sMOTrainingContext.getThreshold();
        if (d17 > 0.0 && d17 < d11) {
            d = d8 + d4 * (d17 - d6) * d13 + d5 * (d18 - d7) * d14 + d19;
        } else if (d18 > 0.0 && d18 < d11) {
            d = d9 + d4 * (d17 - d6) * d14 + d5 * (d18 - d7) * d15 + d19;
        } else {
            double d20 = d8 + d4 * (d17 - d6) * d13 + d5 * (d18 - d7) * d14 + d19;
            double d21 = d9 + d4 * (d17 - d6) * d14 + d5 * (d18 - d7) * d15 + d19;
            d = (d20 + d21) / 2.0;
        }
        sMOTrainingContext.setThreshold(d);
        sMOTrainingContext.setAlpha(n, d17);
        sMOTrainingContext.setAlpha(n2, d18);
        sMOTrainingContext.resetError(n);
        sMOTrainingContext.resetError(n2);
        int n3 = 0;
        while (n3 < sMOTrainingContext.size()) {
            if (n3 != n && n3 != n2 && !sMOTrainingContext.isBound(sMOTrainingContext.getAlpha(n3))) {
                sMOTrainingContext.updateError(n3, d4 * (d17 - d6) * sMOTrainingContext.getKernelValue(n, n3) + d5 * (d18 - d7) * sMOTrainingContext.getKernelValue(n2, n3) + d19 - d);
            }
            ++n3;
        }
        return true;
    }

    public SVMClassifierModel trainModel(SVMTarget sVMTarget, SVMKernel sVMKernel, TrainingListener trainingListener) {
        SMOTrainingContext sMOTrainingContext = new SMOTrainingContext(sVMTarget, sVMKernel, trainingListener);
        int n = 0;
        boolean bl = true;
        while (n > 0 || bl) {
            int n2;
            n = 0;
            if (bl) {
                n2 = 0;
                while (n2 < sMOTrainingContext.size()) {
                    n += this.examineExample(sMOTrainingContext, n2);
                    ++n2;
                }
            } else {
                n2 = 0;
                while (n2 < sMOTrainingContext.size()) {
                    double d = sMOTrainingContext.getAlpha(n2);
                    if (!sMOTrainingContext.isBound(d)) {
                        n += this.examineExample(sMOTrainingContext, n2);
                    }
                    ++n2;
                }
            }
            bl = bl ? false : n == 0;
            sMOTrainingContext.trainingCycleCompleted();
        }
        sMOTrainingContext.trainingCompleted();
        return sMOTrainingContext.getModel();
    }

    final class SMOTrainingContext
    implements TrainingContext {
        private double C;
        private double epsilon;
        private TrainingListener listener;
        private int cycle = 0;
        private TrainingEvent ourEvent;
        private SVMTarget target;
        private SVMClassifierModel model;
        private Object[] items;
        private double[] alphas;
        private double[] targets;
        private double[] E;

        public SMOTrainingContext(SVMTarget sVMTarget, SVMKernel sVMKernel, TrainingListener trainingListener) {
            this.C = SMOTrainer.this.getC();
            this.epsilon = SMOTrainer.this.getEpsilon();
            this.model = new SimpleSVMClassifierModel(sVMKernel, sVMTarget);
            this.model.setThreshold(0.0);
            this.listener = trainingListener;
            this.ourEvent = new TrainingEvent(this);
            this.cycle = 0;
            Set set = sVMTarget.items();
            int n = set.size();
            this.items = new Object[n];
            this.alphas = new double[n];
            this.targets = new double[n];
            this.E = new double[n];
            Iterator iterator = set.iterator();
            int n2 = 0;
            while (iterator.hasNext()) {
                Object e = iterator.next();
                this.items[n2] = e;
                this.targets[n2] = sVMTarget.getTarget(e);
                this.alphas[n2] = this.model.getAlpha(e) / this.targets[n2];
                this.E[n2] = -this.targets[n2];
                ++n2;
            }
        }

        public double getAlpha(int n) {
            return this.alphas[n];
        }

        public double getC() {
            return this.C;
        }

        public int getCurrentCycle() {
            return this.cycle;
        }

        public double getEpsilon() {
            return this.epsilon;
        }

        public double getError(int n) {
            double d = this.getTarget(n);
            double d2 = this.getAlpha(n);
            if (this.isBound(d2)) {
                this.E[n] = this.getModel().classify(this.getItem(n)) - this.getTarget(n);
                return this.E[n];
            }
            return this.E[n];
        }

        public Object getItem(int n) {
            return this.items[n];
        }

        public double getKernelValue(int n, int n2) {
            return this.getModel().getKernel().evaluate(this.getItem(n), this.getItem(n2));
        }

        public SVMClassifierModel getModel() {
            return this.model;
        }

        public SVMTarget getTarget() {
            return this.target;
        }

        public double getTarget(int n) {
            return this.targets[n];
        }

        public double getThreshold() {
            return this.model.getThreshold();
        }

        private boolean isBound(double d) {
            return d <= 0.0 || d >= this.getC();
        }

        public void resetError(int n) {
            this.E[n] = this.getModel().classify(this.getItem(n)) - this.getTarget(n);
        }

        public void setAlpha(int n, double d) {
            this.alphas[n] = d;
            this.model.setAlpha(this.getItem(n), this.getAlpha(n) * this.getTarget(n));
        }

        public void setThreshold(double d) {
            this.model.setThreshold(d);
        }

        public int size() {
            return this.items.length;
        }

        public void trainingCompleted() {
            int n = 0;
            while (n < this.size()) {
                if (this.getAlpha(n) == 0.0) {
                    this.model.removeItem(this.getItem(n));
                }
                ++n;
            }
            if (this.listener != null) {
                this.listener.trainingComplete(this.ourEvent);
            }
        }

        public void trainingCycleCompleted() {
            ++this.cycle;
            if (this.listener != null) {
                this.listener.trainingCycleComplete(this.ourEvent);
            }
        }

        public void updateError(int n, double d) {
            int n2 = n;
            this.E[n2] = this.E[n2] + d;
        }
    }
}

