/*
 * Decompiled with CFR 0.152.
 */
package com.gkano.bioinfo.vcf;

public class VariantKeyExtractor {
    private final KeyFormat format;

    public VariantKeyExtractor(KeyFormat format) {
        this.format = format;
    }

    public String extractKey(String vcfLine) {
        if (vcfLine == null || vcfLine.isEmpty() || vcfLine.startsWith("#")) {
            return null;
        }
        int[] tabPositions = this.findFirstTabs(vcfLine, 5);
        if (tabPositions == null) {
            return null;
        }
        switch (this.format) {
            case CHROM_POS: {
                return this.extractChromPos(vcfLine, tabPositions);
            }
            case CHROM_POS_REF_ALT: {
                return this.extractChromPosRefAlt(vcfLine, tabPositions);
            }
            case VCF_ID: {
                return this.extractVcfId(vcfLine, tabPositions);
            }
        }
        return null;
    }

    private int[] findFirstTabs(String s, int n) {
        int tab;
        int[] positions = new int[n];
        int count = 0;
        int pos = 0;
        while (count < n && pos < s.length() && (tab = s.indexOf(9, pos)) >= 0) {
            positions[count++] = tab;
            pos = tab + 1;
        }
        return (int[])(count >= n ? positions : null);
    }

    private String extractChromPos(String line, int[] tabs) {
        String chrom = line.substring(0, tabs[0]);
        String pos = line.substring(tabs[0] + 1, tabs[1]);
        return chrom + ":" + pos;
    }

    private String extractChromPosRefAlt(String line, int[] tabs) {
        String chrom = line.substring(0, tabs[0]);
        String pos = line.substring(tabs[0] + 1, tabs[1]);
        String ref = line.substring(tabs[2] + 1, tabs[3]);
        String alt = line.substring(tabs[3] + 1, tabs[4]);
        return chrom + ":" + pos + ":" + ref + ":" + alt;
    }

    private String extractVcfId(String line, int[] tabs) {
        String id = line.substring(tabs[1] + 1, tabs[2]);
        if (".".equals(id)) {
            return null;
        }
        return id;
    }

    public static KeyFormat parseFormat(String formatStr) {
        if (formatStr == null) {
            return KeyFormat.CHROM_POS_REF_ALT;
        }
        switch (formatStr.toUpperCase().replace("-", "_")) {
            case "CHROM_POS": {
                return KeyFormat.CHROM_POS;
            }
            case "CHROM_POS_REF_ALT": {
                return KeyFormat.CHROM_POS_REF_ALT;
            }
            case "VCF_ID": 
            case "ID": {
                return KeyFormat.VCF_ID;
            }
        }
        throw new IllegalArgumentException("Unknown variant key format: " + formatStr + ". Valid options: CHROM_POS, CHROM_POS_REF_ALT, VCF_ID");
    }

    public static enum KeyFormat {
        CHROM_POS,
        CHROM_POS_REF_ALT,
        VCF_ID;

    }
}

