# This script servers as both documentation and script to download
# the data file dCovid_diffexp.tsv from Zenodo.
#
# This file is used in the vignette to demonstrate the use of the
# drugfindR package.

# The file that we download is part of a set of differential gene expression
# files that are located in the Zenodo repository at the following URL:
# https://zenodo.org/record/10265182
# These files were generated by the author, who is also the author of the
# publication "Identification of candidate repurposable drugs
# to combat COVID‑19 using a signature‑based approach"
# (https://doi.org/10.1038/s41598-021-84044-9).
#
# This particular file contains the differential gene expression data for the
# patients with COVID-19 compared to the healthy controls.
datasetUrl <- "https://zenodo.org/records/10265182/files/dCovid_diffexp.tsv"

# We download the file to the inst/extdata directory of the package.
location <- file.path("inst", "extdata", "dCovid_diffexp.tsv")
download.file(datasetUrl, location, method = "auto")
