## ----loadLibraries, results = 'hide', echo = FALSE----------------------------

	library(a4Classif)
	library(ALL)


## ----loadData-----------------------------------------------------------------

data(ALL, package = "ALL")
ALL <- addGeneInfo(ALL)
ALL$BTtype <- as.factor(substr(ALL$BT,0,1))


## ----lassoClassification------------------------------------------------------

resultLasso <- lassoClass(object = ALL, groups = "BTtype")
plot(resultLasso, 
	label = TRUE, 
	main = "Lasso coefficients in relation to degree of penalization."
)
topTable(resultLasso, n = 15)


## ----pamClassification--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

resultPam <- pamClass(object = ALL, groups = "BTtype")
plot(resultPam, 
	main = "Pam misclassification error versus number of genes."
)

topTable(resultPam, n = 15)

confusionMatrix(resultPam)


## ----randomForestClassification-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

# select only a subset of the data for computation time reason
ALLSubset <- ALL[sample.int(n = nrow(ALL), size = 100, replace = FALSE), ]

resultRf <- rfClass(object = ALLSubset, groups = "BTtype")
plot(resultRf)
topTable(resultRf, n = 15)


## ----rocCurve-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

ROCcurve(gene = "ABL1", object = ALL, groups = "BTtype")


## ----sessionInformation, echo = FALSE-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
print(sessionInfo())

