/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.readseq.utils.gbregion;

import edu.msu.cme.rdp.readseq.utils.gbregion.ComplementRegion;
import edu.msu.cme.rdp.readseq.utils.gbregion.Extends;
import edu.msu.cme.rdp.readseq.utils.gbregion.JoinRegion;
import edu.msu.cme.rdp.readseq.utils.gbregion.SimpleRegion;
import edu.msu.cme.rdp.readseq.utils.gbregion.SingleSeqRegion;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;

public class RegionParser {
    static final String accnoGiPattern = "(\\d+)|([A-Z_]+\\d+(\\.\\d+)?)|(gi\\|\\d+)";

    public static SingleSeqRegion parse(String regionString) throws IOException {
        StringReader reader = new StringReader(regionString.replaceAll("\\s+", ""));
        return RegionParser.parseRegion(reader);
    }

    private static SingleSeqRegion parseRegion(StringReader in) throws IOException {
        IdentifierOrRange idOrRange = RegionParser.parseIdentifierOrRange(in);
        if (idOrRange.identifier == null) {
            GBRange range = idOrRange.range;
            return new SimpleRegion("", range.rangeStart, range.rangeEnd, range.rangeExtends);
        }
        String identifier = idOrRange.identifier;
        if (identifier.equals("join") || identifier.equals("order")) {
            return RegionParser.parseJoin(in, identifier.equals("order"));
        }
        if (identifier.equals("complement")) {
            return RegionParser.parseComplement(in);
        }
        if (identifier.matches(accnoGiPattern)) {
            idOrRange = RegionParser.parseIdentifierOrRange(in);
            GBRange range = idOrRange.range;
            if (range == null) {
                throw new IOException("Fatal error when trying to parse range \"" + idOrRange.identifier + "\"");
            }
            return new SimpleRegion(identifier, range.rangeStart, range.rangeEnd, range.rangeExtends);
        }
        throw new IOException("Unexpected token \"" + identifier + "\"");
    }

    private static SingleSeqRegion parseJoin(StringReader in, boolean isOrder) throws IOException {
        char c;
        ArrayList<SingleSeqRegion> joinOf = new ArrayList<SingleSeqRegion>();
        String id = null;
        do {
            SingleSeqRegion r = RegionParser.parseRegion(in);
            if (id == null || id.isEmpty()) {
                id = r.getId();
            } else if (!id.equals(r.getId()) && !r.getId().isEmpty()) {
                throw new IOException("SingleSeqRegion can only handle sequences of...a single seq...");
            }
            joinOf.add(r);
            int n = in.read();
            if (n == -1) {
                throw new IOException("Malformed join statement buffer=" + joinOf);
            }
            c = (char)n;
            if (c != ')') continue;
            return new JoinRegion(id, joinOf, isOrder);
        } while (c == ',');
        throw new IOException("Unexpected '" + c + "' in join, buffer=" + joinOf);
    }

    private static SingleSeqRegion parseComplement(StringReader in) throws IOException {
        ComplementRegion ret = new ComplementRegion(RegionParser.parseRegion(in));
        int next = in.read();
        if (next == -1) {
            throw new IOException("Unexpected end of region, last region= " + ((Object)ret).toString());
        }
        if (next != 41) {
            throw new IOException("Unexpected '" + (char)next + "', last region= " + ((Object)ret).toString());
        }
        return ret;
    }

    private static IdentifierOrRange parseIdentifierOrRange(StringReader in) throws IOException {
        int i;
        IdentifierOrRange ret = new IdentifierOrRange();
        StringBuilder buf = new StringBuilder();
        Extends e = Extends.EXACT;
        in.mark(1);
        char c = (char)in.read();
        if (c == '<') {
            e = Extends.BEYOND_BEGIN;
        } else {
            buf.append(c);
        }
        in.mark(1);
        while ((i = in.read()) != -1) {
            c = (char)i;
            if (c == ',' || c == ')') {
                in.reset();
                break;
            }
            if (c == ':' || c == '(' || c == '.') break;
            buf.append(c);
            in.mark(1);
        }
        boolean isIdentifier = false;
        if (c == ':' || c == '(') {
            isIdentifier = true;
        } else if (c == '.' && (c = (char)in.read()) != '.') {
            isIdentifier = true;
            buf.append('.').append(c);
            while ((i = in.read()) != -1 && (c = (char)i) != ':' && c != '(') {
                buf.append(c);
            }
        }
        if (isIdentifier) {
            if (e == Extends.BEYOND_BEGIN) {
                buf.insert(0, "<");
            }
            ret.identifier = buf.toString();
            return ret;
        }
        int rangeStart = new Integer(buf.toString());
        if (c != ',' && c != ')') {
            buf = new StringBuilder();
            c = (char)in.read();
            if (c == '>') {
                e = e == Extends.BEYOND_BEGIN ? Extends.BEYOND_BOTH : Extends.BEYOND_END;
            } else {
                buf.append(c);
            }
            in.mark(1);
            while ((i = in.read()) != -1) {
                c = (char)i;
                if (c == ',' || c == ')') {
                    in.reset();
                    break;
                }
                if (!Character.isDigit(c)) {
                    throw new IOException("Expected digit in range, not " + c);
                }
                buf.append(c);
                in.mark(1);
            }
        }
        int rangeEnd = new Integer(buf.toString());
        GBRange range = new GBRange();
        range.rangeStart = rangeStart;
        range.rangeEnd = rangeEnd;
        range.rangeExtends = e;
        ret.range = range;
        return ret;
    }

    public static void main(String[] args) throws IOException {
        for (String s : args) {
            System.out.println(s);
            System.out.println(RegionParser.parse(s));
            System.out.println();
        }
    }

    private static class GBRange {
        public int rangeStart;
        public int rangeEnd;
        public Extends rangeExtends;

        private GBRange() {
        }
    }

    private static class IdentifierOrRange {
        String identifier;
        GBRange range;

        private IdentifierOrRange() {
        }
    }
}

