/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.classifier.comparison;

import edu.msu.cme.rdp.classifier.comparison.AbstractNode;
import edu.msu.cme.rdp.classifier.comparison.Taxon;
import edu.msu.cme.rdp.classifier.comparison.UncNode;
import java.util.Iterator;

public class PixelCalculatorBean {
    private int s1Total = 0;
    private int s2Total = 0;
    private Taxon taxon = null;
    private float maxPercent = 0.0f;
    private String rank = "";
    private int numOfChildren = 0;
    private double sig99 = 0.01;

    public void setS1Total(int total) {
        this.s1Total = total;
    }

    public void setS2Total(int total) {
        this.s2Total = total;
    }

    public void setTaxonList(Iterator it) {
        float percent = 0.0f;
        this.numOfChildren = 0;
        while (it.hasNext()) {
            Taxon taxon = (Taxon)it.next();
            ++this.numOfChildren;
            if (!taxon.getRank().equals("")) {
                this.rank = taxon.getRank();
            }
            if (this.s1Total > 0 && (percent = (float)taxon.getS1Count() / (float)this.s1Total * 100.0f) > this.maxPercent) {
                this.maxPercent = percent;
            }
            if (this.s2Total <= 0 || !((percent = (float)taxon.getS2Count() / (float)this.s2Total * 100.0f) > this.maxPercent)) continue;
            this.maxPercent = percent;
        }
    }

    public int getNumOfChildren() {
        return this.numOfChildren;
    }

    public String getRank() {
        return this.rank;
    }

    public void setTaxon(Taxon t) {
        this.taxon = t;
    }

    public String getS1PercentStr() {
        float percent = 0.0f;
        if (this.s1Total > 0) {
            percent = (float)Math.round((float)this.taxon.getS1Count() / (float)this.s1Total * 1000.0f) / 10.0f;
        }
        return Float.toString(percent);
    }

    public String getS2PercentStr() {
        float percent = 0.0f;
        if (this.s2Total > 0) {
            percent = (float)Math.round((float)this.taxon.getS2Count() / (float)this.s2Total * 1000.0f) / 10.0f;
        }
        return Float.toString(percent);
    }

    public String getS1GifPercent() {
        int percent = 0;
        if (this.s1Total > 0) {
            percent = Math.round((float)this.taxon.getS1Count() / (float)this.s1Total / this.maxPercent * 10000.0f);
        }
        return Integer.toString(percent) + "%";
    }

    public String getS2GifPercent() {
        int percent = 0;
        if (this.s2Total > 0) {
            percent = Math.round((float)this.taxon.getS2Count() / (float)this.s2Total / this.maxPercent * 10000.0f);
        }
        return Integer.toString(percent) + "%";
    }

    public boolean isSignificant() {
        if (this.taxon instanceof UncNode) {
            return false;
        }
        return ((AbstractNode)this.taxon).getDoubleSignificance() <= this.sig99;
    }
}

