/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.alignment.hmm.scoring;

import edu.msu.cme.rdp.alignment.hmm.ProfileHMM;
import edu.msu.cme.rdp.alignment.hmm.XSTATES;
import edu.msu.cme.rdp.alignment.hmm.scoring.ViterbiScorer;
import edu.msu.cme.rdp.readseq.readers.Sequence;
import java.util.ArrayList;
import java.util.List;

public abstract class HMMScorer {
    protected final ProfileHMM hmm;
    protected final int startingState;
    protected final int modelLength;
    protected final int modelStates;
    private List<double[][]> matrix;
    private static final int M = 0;
    private static final int I = 1;
    private static final int D = 2;
    protected int i;
    public static final float ln2 = (float)StrictMath.log(2.0);
    private double[] bestPossibleScore;
    private List<double[]> xmx;
    private static final double[] nullModels = new double[5000];
    protected List<Double> maxScores = new ArrayList<Double>();

    public HMMScorer(ProfileHMM hmm) {
        this(hmm, -1);
    }

    public HMMScorer(ProfileHMM hmm, int startingState) {
        this.hmm = hmm;
        this.modelLength = hmm.M();
        this.modelStates = hmm.M() - 1;
        this.startingState = startingState;
        this.reset();
    }

    private static double genNull1(int L) {
        float p1 = (float)L / (float)(L + 1);
        float null1 = (float)((double)L * StrictMath.log(p1) + StrictMath.log(1.0f - p1));
        return null1;
    }

    public static double getNull1(int L) {
        if (L < nullModels.length) {
            return nullModels[L];
        }
        return HMMScorer.genNull1(L);
    }

    protected abstract void initializeSM();

    public abstract void consume(char var1);

    protected final void reset() {
        this.i = -1;
        this.matrix = new ArrayList<double[][]>();
        this.xmx = new ArrayList<double[]>();
        this.maxScores = new ArrayList<Double>();
        this.maxScores.add(Double.NEGATIVE_INFINITY);
        this.extend();
        this.initializeSM();
    }

    protected void extend() {
        ++this.i;
        double[][] nextRow = new double[3][this.hmm.M() + 1];
        this.matrix.add(nextRow);
        this.xmx.add(new double[XSTATES.values().length]);
    }

    public Object[] getBestScore() {
        int bestK = -1;
        double score = Double.NEGATIVE_INFINITY;
        double[] mx = this.mmx(this.i);
        double[] dx = this.dmx(this.i);
        for (int k = 2; k <= this.modelLength; ++k) {
            double sc = StrictMath.max(mx[k], dx[k]);
            if (sc > score) {
                score = sc;
                bestK = k;
            }
            score = StrictMath.max(score, sc);
        }
        return new Object[]{bestK, score};
    }

    public Object[] getBestScore(int mp) {
        int bestK = mp;
        double[] mx = this.mmx(this.i);
        double[] dx = this.dmx(this.i);
        return new Object[]{bestK, StrictMath.max(mx[mp], dx[mp])};
    }

    public double getMaxScore() {
        double score = this.maxScores.get(this.i);
        return (score - HMMScorer.getNull1(this.i)) / (double)ln2;
    }

    public double getMaxScorePrint() {
        double score = Double.NEGATIVE_INFINITY;
        int maxState = -1;
        double[] mx = this.mmx(this.i);
        double[] dx = this.dmx(this.i);
        boolean m = false;
        for (int k = this.startingState - 1; k <= this.modelLength; ++k) {
            double sc = StrictMath.max(mx[k], dx[k]);
            if (sc > score) {
                m = sc == mx[k];
                score = sc;
                maxState = k;
            }
            score = StrictMath.max(score, sc);
        }
        System.out.println("Max state: " + maxState + " seq pos: " + this.i + " match state?: " + m + " score: " + score + " scores[startingState - 1]: " + mx[this.startingState - 1] + ", " + dx[this.startingState - 1] + "scores[startingState - 2]: " + mx[this.startingState - 2] + ", " + dx[this.startingState - 2]);
        System.out.println(this.mmx(0, 0) + ", " + this.dmx(0, 0) + "\t" + this.mmx(0, 1) + ", " + this.dmx(0, 1));
        System.out.println(this.mmx(1, 0) + ", " + this.dmx(1, 0) + "\t" + this.mmx(1, 1) + ", " + this.dmx(1, 1));
        System.out.println();
        return (score - HMMScorer.getNull1(this.i)) / (double)ln2;
    }

    public double getScore() {
        double score = Math.max(this.mmx(this.i, this.hmm.M()), this.dmx(this.i, this.hmm.M()));
        return (score - HMMScorer.getNull1(this.i)) / (double)ln2;
    }

    public void contract() {
        if (this.i >= 0) {
            this.matrix.remove(this.i);
            this.xmx.remove(this.i);
            this.maxScores.remove(this.i);
            --this.i;
        }
    }

    public final int getQueryLength() {
        return this.i;
    }

    protected final double mmx(int i, int k) {
        return this.matrix.get(i)[0][k];
    }

    protected final double imx(int i, int k) {
        return this.matrix.get(i)[1][k];
    }

    protected final double dmx(int i, int k) {
        return this.matrix.get(i)[2][k];
    }

    protected final double xmx(int i, XSTATES s) {
        return this.xmx.get(i)[s.ordinal()];
    }

    protected final double[] mmx(int i) {
        return this.matrix.get(i)[0];
    }

    protected final double[] imx(int i) {
        return this.matrix.get(i)[1];
    }

    protected final double[] dmx(int i) {
        return this.matrix.get(i)[2];
    }

    protected final double[] xmx(int i) {
        return this.xmx.get(i);
    }

    protected final void mmx(int i, int k, double val) {
        this.matrix.get((int)i)[0][k] = val;
    }

    protected final void imx(int i, int k, double val) {
        this.matrix.get((int)i)[1][k] = val;
    }

    protected final void dmx(int i, int k, double val) {
        this.matrix.get((int)i)[2][k] = val;
    }

    protected final void xmx(int i, XSTATES s, double val) {
        this.xmx.get((int)i)[s.ordinal()] = val;
    }

    public static double scoreSequence(ProfileHMM hmm, Sequence seq) {
        return HMMScorer.scoreSequence(hmm, seq.getSeqString());
    }

    public static double scoreSequence(ProfileHMM hmm, String seq) {
        char[] bases;
        ViterbiScorer scorer = new ViterbiScorer(hmm);
        for (char base : bases = seq.toCharArray()) {
            scorer.consume(base);
        }
        return scorer.getMaxScore();
    }

    static {
        for (int i = 0; i < 5000; ++i) {
            HMMScorer.nullModels[i] = HMMScorer.genNull1(i);
        }
    }
}

