/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils.bytecode;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.biojava.utils.bytecode.BranchFixup;
import org.biojava.utils.bytecode.ChildContext;
import org.biojava.utils.bytecode.CodeClass;
import org.biojava.utils.bytecode.CodeContext;
import org.biojava.utils.bytecode.CodeException;
import org.biojava.utils.bytecode.CodeMethod;
import org.biojava.utils.bytecode.ConstantPool;
import org.biojava.utils.bytecode.ExceptionMemento;
import org.biojava.utils.bytecode.Label;
import org.biojava.utils.bytecode.LocalVariable;
import org.biojava.utils.bytecode.OutstandingReference;
import org.biojava.utils.bytecode.ParentContext;
import org.biojava.utils.bytecode.SimpleReference;

class MethodRootContext
implements CodeContext,
ParentContext {
    private final CodeClass codeClass;
    private final CodeMethod codeMethod;
    private final ConstantPool cpool;
    private byte[] sink;
    private int offset;
    private List outstandingRefs = new ArrayList();
    private Map markedLabels = new HashMap();
    private Map localVariables = new HashMap();
    private int usedLocals;
    private int maxLocals;
    private List exceptionTable = new ArrayList();

    MethodRootContext(CodeClass codeClass, CodeMethod codeMethod, ConstantPool constantPool) {
        this.codeClass = codeClass;
        this.codeMethod = codeMethod;
        this.cpool = constantPool;
        this.sink = new byte[65536];
        this.offset = 0;
        this.maxLocals = 0;
        this.usedLocals = 0;
    }

    public CodeClass getCodeClass() {
        return this.codeClass;
    }

    public CodeMethod getCodeMethod() {
        return this.codeMethod;
    }

    public ConstantPool getConstants() {
        return this.cpool;
    }

    public void writeByte(byte by) {
        this.sink[this.offset++] = by;
    }

    public void writeShort(int n) {
        this.sink[this.offset++] = (byte)(n >> 8 & 0xFF);
        this.sink[this.offset++] = (byte)(n & 0xFF);
    }

    public void writeShortAt(int n, int n2) {
        this.sink[n] = (byte)(n2 >> 8 & 0xFF);
        this.sink[n + 1] = (byte)(n2 & 0xFF);
    }

    public void writeLabel(Label label) {
        this.outstandingRefs.add(new BranchFixup(label, this.getOffset(), this));
        this.writeShort(0);
    }

    public void markLabel(Label label) throws CodeException {
        if (this.markedLabels.containsKey(label)) {
            throw new CodeException("Attempt to duplicate marked label");
        }
        this.markedLabels.put(label, new Integer(this.getOffset()));
    }

    public int resolveLocal(LocalVariable localVariable) {
        Integer n = (Integer)this.localVariables.get(localVariable);
        if (n != null) {
            return n;
        }
        int n2 = this.usedLocals;
        this.usedLocals += localVariable.needSlots();
        this.setMaxLocals(this.usedLocals);
        this.localVariables.put(localVariable, new Integer(n2));
        return n2;
    }

    public int resolveLocalNoCreate(LocalVariable localVariable) {
        Integer n = (Integer)this.localVariables.get(localVariable);
        if (n != null) {
            return n;
        }
        return -1;
    }

    public int getOffset() {
        return this.offset;
    }

    public void open() {
    }

    public void close() throws CodeException {
        ListIterator listIterator = this.outstandingRefs.listIterator();
        while (listIterator.hasNext()) {
            OutstandingReference outstandingReference = (OutstandingReference)listIterator.next();
            Integer n = (Integer)this.markedLabels.get(outstandingReference.getLabel());
            if (n != null) {
                outstandingReference.resolve(n);
                continue;
            }
            throw new CodeException("Reference to label " + outstandingReference.getLabel() + " still outstanding at top level");
        }
    }

    public CodeContext subContext() {
        return new ChildContext(this);
    }

    public void promoteOutstandingReference(OutstandingReference outstandingReference) {
        this.outstandingRefs.add(outstandingReference);
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.sink, 0, this.offset);
    }

    public void setMaxLocals(int n) {
        if (n > this.maxLocals) {
            this.maxLocals = n;
        }
    }

    public int getMaxLocals() {
        return this.maxLocals;
    }

    public int getUsedLocals() {
        return this.usedLocals;
    }

    public void addExceptionTableEntry(Label label, Label label2, CodeClass codeClass, Label label3) {
        SimpleReference simpleReference = new SimpleReference(label);
        SimpleReference simpleReference2 = new SimpleReference(label2);
        SimpleReference simpleReference3 = new SimpleReference(label3);
        this.outstandingRefs.add(simpleReference);
        this.outstandingRefs.add(simpleReference2);
        this.outstandingRefs.add(simpleReference3);
        this.addExceptionTableEntry(new ExceptionMemento(simpleReference, simpleReference2, codeClass, simpleReference3));
    }

    public void addExceptionTableEntry(ExceptionMemento exceptionMemento) {
        this.exceptionTable.add(exceptionMemento);
    }

    public List getExceptionTable() {
        return Collections.unmodifiableList(this.exceptionTable);
    }
}

