/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io;

import java.io.NotSerializableException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.bio.SimpleAnnotation;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.impl.SimpleSequence;
import org.biojava.bio.seq.io.ChunkedSymbolListBuilder;
import org.biojava.bio.seq.io.ParseException;
import org.biojava.bio.seq.io.SequenceBuilder;
import org.biojava.bio.seq.io.SequenceBuilderFactory;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.StaticMemberPlaceHolder;

public class SimpleSequenceBuilder
implements SequenceBuilder {
    public static final SequenceBuilderFactory FACTORY;
    private String name;
    private String uri;
    private ChunkedSymbolListBuilder slBuilder;
    private Annotation annotation = new SimpleAnnotation();
    private Set rootFeatures = new HashSet();
    private List featureStack = new ArrayList();
    static /* synthetic */ Class class$org$biojava$bio$seq$io$SimpleSequenceBuilder;

    static {
        class Org_biojava_bio_seq_io_SimpleSequenceBuilder$1 {
            /* synthetic */ Org_biojava_bio_seq_io_SimpleSequenceBuilder$1() {
            }
        }
        FACTORY = new SSBFactory();
    }

    public SimpleSequenceBuilder() {
        this.slBuilder = new ChunkedSymbolListBuilder();
    }

    public void addFeatureProperty(Object object, Object object2) throws ParseException {
        try {
            int n = this.featureStack.size();
            TemplateWithChildren templateWithChildren = (TemplateWithChildren)this.featureStack.get(n - 1);
            this.addProperty(templateWithChildren.template.annotation, object, object2);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ParseException(indexOutOfBoundsException, "Attempted to add annotation to a feature when no startFeature had been invoked");
        }
    }

    protected void addProperty(Annotation annotation, Object object, Object arrayList) {
        if (arrayList == null) {
            return;
        }
        Object object2 = null;
        ArrayList<Object> arrayList2 = arrayList;
        try {
            object2 = annotation.getProperty(object);
        }
        catch (NoSuchElementException noSuchElementException) {}
        if (object2 != null) {
            if (object2 instanceof String) {
                arrayList2 = String.valueOf((String)object2) + " " + ((Object)arrayList2).toString();
            } else if (object2 instanceof Collection) {
                ((Collection)object2).add(arrayList2);
                arrayList2 = object2;
            } else {
                ArrayList<Object> arrayList3 = new ArrayList<Object>();
                arrayList3.add(object2);
                arrayList3.add(arrayList2);
                arrayList2 = arrayList3;
            }
        }
        try {
            annotation.setProperty(object, arrayList2);
        }
        catch (ChangeVetoException changeVetoException) {
            throw new BioError(changeVetoException, "Annotation should be modifiable");
        }
    }

    public void addSequenceProperty(Object object, Object object2) {
        this.addProperty(this.annotation, object, object2);
    }

    public void addSymbols(Alphabet alphabet, Symbol[] symbolArray, int n, int n2) throws IllegalAlphabetException {
        this.slBuilder.addSymbols(alphabet, symbolArray, n, n2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void endFeature() {
        if (this.featureStack.size() == 0) {
            throw new BioError("Assertion failed: Not within a feature");
        }
        this.featureStack.remove(this.featureStack.size() - 1);
    }

    public void endSequence() {
    }

    private void makeChildFeatures(Feature feature, Set set) throws Exception {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            TemplateWithChildren templateWithChildren = (TemplateWithChildren)iterator.next();
            Feature feature2 = feature.createFeature(templateWithChildren.template);
            if (templateWithChildren.children == null) continue;
            this.makeChildFeatures(feature2, templateWithChildren.children);
        }
    }

    public Sequence makeSequence() {
        SymbolList symbolList = this.slBuilder.makeSymbolList();
        SimpleSequence simpleSequence = new SimpleSequence(symbolList, this.uri, this.name, this.annotation);
        try {
            Iterator iterator = this.rootFeatures.iterator();
            while (iterator.hasNext()) {
                TemplateWithChildren templateWithChildren = (TemplateWithChildren)iterator.next();
                Feature feature = simpleSequence.createFeature(templateWithChildren.template);
                if (templateWithChildren.children == null) continue;
                this.makeChildFeatures(feature, templateWithChildren.children);
            }
        }
        catch (Exception exception) {
            throw new BioError(exception, "Couldn't create feature");
        }
        return simpleSequence;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setURI(String string) {
        this.uri = string;
    }

    public void startFeature(Feature.Template template) {
        TemplateWithChildren templateWithChildren = new TemplateWithChildren();
        templateWithChildren.template = template;
        int n = this.featureStack.size();
        if (n == 0) {
            this.rootFeatures.add(templateWithChildren);
        } else {
            TemplateWithChildren templateWithChildren2 = (TemplateWithChildren)this.featureStack.get(n - 1);
            if (templateWithChildren2.children == null) {
                templateWithChildren2.children = new HashSet();
            }
            templateWithChildren2.children.add(templateWithChildren);
        }
        this.featureStack.add(templateWithChildren);
    }

    public void startSequence() {
    }

    private static class SSBFactory
    implements SequenceBuilderFactory,
    Serializable {
        private SSBFactory() {
        }

        public SequenceBuilder makeSequenceBuilder() {
            return new SimpleSequenceBuilder();
        }

        private Object writeReplace() throws ObjectStreamException {
            try {
                return new StaticMemberPlaceHolder((class$org$biojava$bio$seq$io$SimpleSequenceBuilder != null ? class$org$biojava$bio$seq$io$SimpleSequenceBuilder : (class$org$biojava$bio$seq$io$SimpleSequenceBuilder = SimpleSequenceBuilder.class$("org.biojava.bio.seq.io.SimpleSequenceBuilder"))).getField("FACTORY"));
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new NotSerializableException(noSuchFieldException.getMessage());
            }
        }
    }

    private static class TemplateWithChildren {
        Feature.Template template;
        Set children;

        TemplateWithChildren() {
        }
    }
}

