/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.dp.onehead;

import java.util.Iterator;
import org.biojava.bio.dp.onehead.DPCursor;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;

abstract class AbstractCursor
implements DPCursor {
    private static final Symbol gap = AlphabetManager.getGapSymbol();
    private Iterator symIterator;
    private Symbol currentRes;
    private Symbol lastRes;

    protected AbstractCursor() {
    }

    public AbstractCursor(Iterator iterator) {
        this.symIterator = iterator;
        this.currentRes = gap;
        this.lastRes = gap;
    }

    public void advance() {
        this.lastRes = this.currentRes;
        this.currentRes = this.symIterator.hasNext() ? (Symbol)this.symIterator.next() : gap;
    }

    public boolean canAdvance() {
        return this.symIterator.hasNext() || this.currentRes != gap;
    }

    public abstract double[] currentCol();

    public Symbol currentRes() {
        return this.currentRes;
    }

    public abstract double[] lastCol();

    public Symbol lastRes() {
        return this.lastRes;
    }

    public abstract int length();

    public abstract SymbolList symList();
}

