/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;

public class SimpleAnnotation
implements Annotation,
Serializable {
    protected transient ChangeSupport changeSupport = null;
    private Map properties;

    public SimpleAnnotation() {
    }

    public SimpleAnnotation(Map map) {
        if (map == null) {
            throw new IllegalArgumentException("Null annotation Map not allowed. Use an empy map instead.");
        }
        if (map.isEmpty()) {
            return;
        }
        Map map2 = this.getProperties();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            map2.put(k, map.get(k));
        }
    }

    public SimpleAnnotation(Annotation annotation) throws IllegalArgumentException {
        if (annotation == null) {
            throw new IllegalArgumentException("Null annotation not allowed. Use Annotation.EMPTY_ANNOTATION instead.");
        }
        if (annotation == Annotation.EMPTY_ANNOTATION) {
            return;
        }
        Map map = this.getProperties();
        Iterator iterator = annotation.keys().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            try {
                map.put(e, annotation.getProperty(e));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new BioError(illegalArgumentException, "Property was there and then dissapeared: " + e);
            }
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        if (this.changeSupport == null) {
            this.changeSupport = new ChangeSupport();
        }
        ChangeSupport changeSupport = this.changeSupport;
        synchronized (changeSupport) {
            this.changeSupport.addChangeListener(changeListener);
        }
    }

    public void addChangeListener(ChangeListener changeListener, ChangeType changeType) {
        if (this.changeSupport == null) {
            this.changeSupport = new ChangeSupport();
        }
        ChangeSupport changeSupport = this.changeSupport;
        synchronized (changeSupport) {
            this.changeSupport.addChangeListener(changeListener, changeType);
        }
    }

    public Map asMap() {
        return new HashMap(this.getProperties());
    }

    public boolean containsProperty(Object object) {
        if (this.propertiesAllocated()) {
            return this.properties.containsKey(object);
        }
        return false;
    }

    protected final Map getProperties() {
        if (!this.propertiesAllocated()) {
            this.properties = new HashMap();
        }
        return this.properties;
    }

    public Object getProperty(Object object) throws NoSuchElementException {
        Map map;
        if (this.propertiesAllocated() && (map = this.getProperties()).containsKey(object)) {
            return map.get(object);
        }
        throw new NoSuchElementException("Property " + object + " unknown");
    }

    public Set keys() {
        if (this.propertiesAllocated()) {
            return this.properties.keySet();
        }
        return Collections.EMPTY_SET;
    }

    protected final boolean propertiesAllocated() {
        return this.properties != null;
    }

    public void removeChangeListener(ChangeListener changeListener) {
        if (this.changeSupport != null) {
            ChangeSupport changeSupport = this.changeSupport;
            synchronized (changeSupport) {
                this.changeSupport.removeChangeListener(changeListener);
            }
        }
    }

    public void removeChangeListener(ChangeListener changeListener, ChangeType changeType) {
        if (this.changeSupport != null) {
            ChangeSupport changeSupport = this.changeSupport;
            synchronized (changeSupport) {
                this.changeSupport.removeChangeListener(changeListener, changeType);
            }
        }
    }

    public void setProperty(Object object, Object object2) throws ChangeVetoException {
        if (this.changeSupport == null) {
            this.getProperties().put(object, object2);
        } else {
            Map map = this.getProperties();
            ChangeEvent changeEvent = new ChangeEvent(this, Annotation.PROPERTY, new Object[]{object, object2}, new Object[]{object, map.get(object)});
            ChangeSupport changeSupport = this.changeSupport;
            synchronized (changeSupport) {
                this.changeSupport.firePreChangeEvent(changeEvent);
                map.put(object, object2);
                this.changeSupport.firePostChangeEvent(changeEvent);
            }
        }
    }

    public String toString() {
        Object k;
        StringBuffer stringBuffer = new StringBuffer("{");
        Map map = this.getProperties();
        Iterator iterator = map.keySet().iterator();
        if (iterator.hasNext()) {
            k = iterator.next();
            stringBuffer.append(String.valueOf(String.valueOf(k)) + "=" + map.get(k));
        }
        while (iterator.hasNext()) {
            k = iterator.next();
            stringBuffer.append("," + k + "=" + map.get(k));
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

