/*
 * Decompiled with CFR 0.152.
 */
package jal.BYTE;

import jal.BYTE.BinaryOperator;

public final class Numeric {
    public static byte accumulate(byte[] byArray, int n, int n2, byte by) {
        byte by2 = by;
        while (n < n2) {
            by2 = (byte)(by2 + byArray[n++]);
        }
        return by2;
    }

    public static byte accumulate(byte[] byArray, int n, int n2, byte by, BinaryOperator binaryOperator) {
        byte by2 = by;
        while (n < n2) {
            by2 = binaryOperator.apply(by2, byArray[n++]);
        }
        return by2;
    }

    public static byte inner_product(byte[] byArray, byte[] byArray2, int n, int n2, int n3, byte by) {
        byte by2 = by;
        while (n < n2) {
            by2 = (byte)(by2 + byArray[n++] * byArray2[n3++]);
        }
        return by2;
    }

    public static byte inner_product(byte[] byArray, byte[] byArray2, int n, int n2, int n3, byte by, BinaryOperator binaryOperator, BinaryOperator binaryOperator2) {
        byte by2 = by;
        while (n < n2) {
            by2 = binaryOperator.apply(by2, binaryOperator2.apply(byArray[n++], byArray2[n3++]));
        }
        return by2;
    }

    public static int partial_sum(byte[] byArray, byte[] byArray2, int n, int n2, int n3) {
        if (n < n2) {
            byArray2[n3] = byArray[n];
            byte by = byArray2[n3];
            while (++n < n2) {
                by = (byte)(by + byArray[n]);
                byArray2[++n3] = by;
            }
            return n3 + 1;
        }
        return n3;
    }

    public static int partial_sum(byte[] byArray, byte[] byArray2, int n, int n2, int n3, BinaryOperator binaryOperator) {
        if (n < n2) {
            byArray2[n3] = byArray[n];
            byte by = byArray2[n3];
            while (++n < n2) {
                by = binaryOperator.apply(by, byArray[n]);
                byArray2[++n3] = by;
            }
            return n3 + 1;
        }
        return n3;
    }

    public static int adjacent_difference(byte[] byArray, byte[] byArray2, int n, int n2, int n3) {
        if (n < n2) {
            byArray2[n3] = byArray[n];
            byte by = byArray[n];
            while (++n < n2) {
                byte by2 = byArray[n];
                byArray2[++n3] = (byte)(by2 - by);
                by = by2;
            }
            return n3 + 1;
        }
        return n3;
    }

    public static int adjacent_difference(byte[] byArray, byte[] byArray2, int n, int n2, int n3, BinaryOperator binaryOperator) {
        if (n < n2) {
            byArray2[n3] = byArray[n];
            byte by = byArray[n];
            while (++n < n2) {
                byte by2 = byArray[n];
                byArray2[++n3] = binaryOperator.apply(by2, by);
                by = by2;
            }
            return n3 + 1;
        }
        return n3;
    }

    private Numeric() {
    }
}

