/*
 * Decompiled with CFR 0.152.
 */
package eponine.model;

import eponine.model.DiscreteDistribution;

public class SquareWaveDistribution
implements DiscreteDistribution {
    private int width;
    private double unitProb;

    public SquareWaveDistribution(int n) {
        this.width = n;
        this.unitProb = 1.0 / (double)(1 + 2 * n);
    }

    public int getWidth() {
        return this.width;
    }

    public int getMin() {
        return -this.width;
    }

    public int getMax() {
        return this.width;
    }

    public double probability(int n) {
        if (Math.abs(n) <= this.width) {
            return this.unitProb;
        }
        return 0.0;
    }

    public double probabilityDivMax(int n) {
        if (Math.abs(n) <= this.width) {
            return 1.0;
        }
        return 0.0;
    }

    public int hashCode() {
        return this.width * 100000;
    }

    public boolean equals(Object object) {
        if (!(object instanceof SquareWaveDistribution)) {
            return false;
        }
        SquareWaveDistribution squareWaveDistribution = (SquareWaveDistribution)object;
        return squareWaveDistribution.getWidth() == this.width;
    }
}

