/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.igsp.gkde;

import edu.duke.igsp.gkde.KDEChromosome;
import edu.duke.igsp.gkde.Util;
import edu.duke.igsp.gkde.format.BedDensityWriter;
import edu.duke.igsp.gkde.format.BedReader;
import edu.duke.igsp.gkde.format.DensityWriter;
import edu.duke.igsp.gkde.format.NpfDensityWriter;
import edu.duke.igsp.gkde.format.WiggleDensityWriter;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class Main {
    public static void main(String[] argv) throws Exception {
        Options opts = new Options();
        opts.addOption("s", true, "wiggle track step (default=1)");
        opts.addOption("l", true, "feature length (default=600)");
        opts.addOption("f", true, "fragment size (default=estimated from data)");
        opts.addOption("wg", true, "wg threshold set (default = calculated)");
        opts.addOption("c", true, "genomic count of sequence reads (default = calculated)");
        opts.addOption("h", false, "print usage");
        OptionBuilder.withArgName((String)"input dir");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"input directory (default=current directory)");
        OptionBuilder.isRequired((boolean)false);
        opts.addOption(OptionBuilder.create((String)"d"));
        OptionBuilder.withArgName((String)"output dir");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"output directory (default=current directory)");
        OptionBuilder.isRequired((boolean)false);
        opts.addOption(OptionBuilder.create((String)"o"));
        OptionBuilder.withArgName((String)"background dir");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"background directory (default=none)");
        OptionBuilder.isRequired((boolean)false);
        opts.addOption(OptionBuilder.create((String)"b"));
        OptionBuilder.withArgName((String)"ploidy dir");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"ploidy/input directory (default=none)");
        OptionBuilder.isRequired((boolean)false);
        opts.addOption(OptionBuilder.create((String)"p"));
        OptionBuilder.withArgName((String)"wig | bed | npf");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"output format (default wig)");
        OptionBuilder.isRequired((boolean)false);
        opts.addOption(OptionBuilder.create((String)"of"));
        opts.addOption("t", true, "threshold (standard deviations) (default=4.0)");
        opts.addOption("v", false, "verbose output");
        GnuParser parser = new GnuParser();
        int fragment_size = -1;
        int fragment_offset = 0;
        long featureLength = 600L;
        float threshold = 4.0f;
        int step = 1;
        boolean showHelp = false;
        boolean verbose = false;
        String inputDirectory = null;
        String backgroundDirectory = null;
        String ploidyDirectory = null;
        String[] files = null;
        String[] bgfiles = new String[]{};
        String[] ipfiles = new String[]{};
        String outputFormat = "wig";
        File outputDirectory = new File(System.getProperty("user.dir"));
        long bandwidth = 0L;
        long window = 0L;
        long ncuts = 0L;
        float temp_threshold = 0.0f;
        System.out.println("F-Seq Version 1.85");
        try {
            String out;
            CommandLine cmd = parser.parse(opts, argv);
            showHelp = cmd.hasOption("h");
            verbose = cmd.hasOption("v");
            if (cmd.hasOption("s")) {
                step = Integer.parseInt(cmd.getOptionValue("s"));
            }
            if (cmd.hasOption("f")) {
                fragment_size = Integer.parseInt(cmd.getOptionValue("f"));
            }
            if (cmd.hasOption("d")) {
                inputDirectory = cmd.getOptionValue("d");
            }
            if (cmd.hasOption("b")) {
                backgroundDirectory = cmd.getOptionValue("b");
            }
            if (cmd.hasOption("p")) {
                ploidyDirectory = cmd.getOptionValue("p");
            }
            if (cmd.hasOption("l")) {
                featureLength = Long.parseLong(cmd.getOptionValue("l"));
            }
            if (cmd.hasOption("of") && !(outputFormat = cmd.getOptionValue("of")).equals("wig") && !outputFormat.equals("bed") && !outputFormat.equals("npf")) {
                System.out.println("Parameter error: output format must be 'wig' or 'bed'.");
                showHelp = true;
            }
            if (cmd.hasOption("t")) {
                threshold = Float.parseFloat(cmd.getOptionValue("t"));
            }
            if (cmd.hasOption("o") && !(outputDirectory = new File(out = cmd.getOptionValue("o"))).exists() && !outputDirectory.isDirectory()) {
                System.out.println("Output directory '" + out + "' is not a valid directory.");
                showHelp = true;
            }
            if (cmd.hasOption("wg")) {
                temp_threshold = Float.parseFloat(cmd.getOptionValue("wg"));
            }
            if (cmd.hasOption("c")) {
                ncuts = Long.parseLong(cmd.getOptionValue("c"));
            }
            files = cmd.getArgs();
        }
        catch (Exception e) {
            System.out.println("Error parsing arguments: " + e.getMessage());
            e.printStackTrace();
            showHelp = true;
        }
        if (showHelp || inputDirectory == null && files.length == 0) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("fseq [options]... [file(s)]...", opts);
            System.exit(1);
        }
        File[] pfiles = Main.getFiles(inputDirectory, files);
        File[] background_files = Main.getFiles(backgroundDirectory, bgfiles);
        File[] ploidy_files = Main.getFiles(ploidyDirectory, ipfiles);
        KDEChromosome[] chrs = BedReader.read(pfiles);
        if (fragment_size == -1) {
            fragment_size = Main.wgShiftCalc(chrs);
        }
        fragment_offset = fragment_size / 2;
        if (ncuts == 0L) {
            for (int i = 0; i < chrs.length; ++i) {
                ncuts += chrs[i].getLength();
            }
        }
        KDEChromosome.Settings settings = null;
        settings = bandwidth > 0L || window > 0L ? new KDEChromosome.Settings(bandwidth, window, threshold, fragment_offset, ncuts) : new KDEChromosome.Settings(featureLength, threshold, fragment_offset, ncuts);
        float wg_threshold = Main.wgThreshold(settings, chrs);
        if (temp_threshold != 0.0f) {
            wg_threshold = temp_threshold;
        }
        if (verbose) {
            System.out.println("Settings: ");
            System.out.println("\twindow=" + settings.window * 2L);
            System.out.println("\tbandwidth=" + settings.bandwidth);
            System.out.println("\tthreshold = " + wg_threshold);
            System.out.println("\test. fragment size = " + fragment_size);
            System.out.println("\tsequence length = " + chrs[0].getSequenceLength());
        }
        for (int i = 0; i < chrs.length; ++i) {
            if (chrs[i].getFirstPos() == chrs[i].getLastPos()) {
                System.out.println("Warning: " + chrs[i].getChromosome() + " has size zero.  Skipping.");
                continue;
            }
            File ofile = Util.makeUniqueFileWithExtension(outputDirectory, chrs[i].getChromosome(), outputFormat);
            DensityWriter dw = null;
            dw = outputFormat.equals("wig") ? new WiggleDensityWriter(ofile, chrs[i].getChromosome(), chrs[i].getFirstPos(), step) : (outputFormat.equals("npf") ? new NpfDensityWriter(ofile, chrs[i].getChromosome(), chrs[i].getFirstPos(), step) : new BedDensityWriter(ofile, chrs[i].getChromosome(), chrs[i].getFirstPos(), step));
            chrs[i].run(settings, dw, verbose, wg_threshold, background_files, ploidy_files);
            dw.close();
        }
    }

    private static float computeSD(KDEChromosome.Settings settings, KDEChromosome[] chrs) {
        Random r = new Random();
        double size = 0.0;
        double ncuts = 0.0;
        for (int i = 0; i < chrs.length; ++i) {
            size += (double)((int)Math.abs(chrs[i].getLastPos() - chrs[i].getFirstPos()));
            ncuts += (double)chrs[i].getLength();
        }
        int totalWindow = 1 + (int)(settings.window * 2L);
        int cutDensity = (int)(ncuts / size * (double)totalWindow);
        int thresholdIterations = 10000;
        double[] densities = new double[thresholdIterations];
        long[] cuts = new long[cutDensity];
        for (int i = 0; i < thresholdIterations; ++i) {
            for (int j = 0; j < cuts.length; ++j) {
                cuts[j] = r.nextInt(totalWindow);
            }
            Arrays.sort(cuts);
            densities[i] = Main.density(settings, settings.window, (int)((double)cuts.length / 2.0), cuts);
        }
        double std = Util.std(densities);
        return (float)std;
    }

    private static float wgThreshold(KDEChromosome.Settings settings, KDEChromosome[] chrs) {
        Random r = new Random();
        double size = 0.0;
        double ncuts = 0.0;
        for (int i = 0; i < chrs.length; ++i) {
            size += (double)((int)Math.abs(chrs[i].getLastPos() - chrs[i].getFirstPos()));
            ncuts += (double)chrs[i].getLength();
        }
        int totalWindow = 1 + (int)(settings.window * 2L);
        int cutDensity = (int)(ncuts / size * (double)totalWindow);
        int thresholdIterations = 10000;
        double[] densities = new double[thresholdIterations];
        long[] cuts = new long[cutDensity];
        for (int i = 0; i < thresholdIterations; ++i) {
            for (int j = 0; j < cuts.length; ++j) {
                cuts[j] = r.nextInt(totalWindow);
            }
            Arrays.sort(cuts);
            densities[i] = Main.density(settings, settings.window, (int)((double)cuts.length / 2.0), cuts);
        }
        double mean = Util.mean(densities);
        double std = Util.std(densities);
        return (float)(mean + (double)settings.threshold * std);
    }

    private static int wgShiftCalc(KDEChromosome[] chrs) {
        int max_chr = 0;
        long max_chr_length = chrs[0].getLength();
        for (int i = 0; i < chrs.length; ++i) {
            if (chrs[i].getLength() <= max_chr_length) continue;
            max_chr = i;
            max_chr_length = chrs[i].getLength();
        }
        KDEChromosome.Sequence[] seqs = chrs[max_chr].getCuts();
        ArrayList<Integer> d_temp = new ArrayList<Integer>();
        int k = 0;
        while ((long)k < max_chr_length && !seqs[k].getStrand()) {
            ++k;
        }
        int max_range = 500;
        int max = 1000000;
        int prior = 150;
        if (max > seqs.length - max_range - k) {
            max = seqs.length - max_range - k;
        }
        for (int j = k; j < k + max && (long)j <= max_chr_length; ++j) {
            if (!seqs[j].getStrand()) continue;
            long last_pos = seqs[j].getPosition();
            int back_check = j - 10000;
            if (j < 10000) {
                back_check = j;
            }
            for (int i = back_check; i < j + 10000 && i < max; ++i) {
                if (seqs[i].getStrand() || Math.abs(seqs[i].getPosition() - last_pos - (long)prior) >= (long)max_range) continue;
                Integer temp = new Integer((int)(seqs[i].getPosition() - last_pos));
                d_temp.add(temp);
            }
        }
        int[] d = new int[d_temp.size()];
        for (int j = 0; j < d.length; ++j) {
            d[j] = (Integer)d_temp.get(j);
        }
        Arrays.sort(d);
        int median = d.length % 2 == 0 ? (int)((double)(d[(int)Math.floor((double)d.length / 2.0)] + d[(int)Math.ceil((double)d.length / 2.0)]) / 2.0) : d[d.length / 2];
        return median;
    }

    private static float density(KDEChromosome.Settings settings, long chromPos, int cutIdx, long[] cuts) {
        int d;
        int i;
        long minPos = chromPos - settings.window;
        long maxPos = chromPos + settings.window;
        double[] PRECOMPUTE = settings.precompute;
        double sum = 0.0;
        for (i = cutIdx - 1; i > -1 && cuts[i] >= minPos; --i) {
            d = Math.abs((int)(cuts[i] - chromPos));
            sum += settings.precompute[d];
        }
        for (i = cutIdx; i < cuts.length && cuts[i] <= maxPos; ++i) {
            d = Math.abs((int)(cuts[i] - chromPos));
            if (d > PRECOMPUTE.length - 1) {
                throw new IllegalStateException();
            }
            sum += PRECOMPUTE[d];
        }
        return (float)(sum / (double)settings.bandwidth);
    }

    private static File[] getFiles(String directory, String[] files) {
        File[] inputFiles = null;
        if (directory != null) {
            File dir = new File(directory);
            if (!dir.exists() || !dir.isDirectory()) {
                System.out.println("Directory parameter " + directory + " does not exist or is not a directory.");
                System.exit(1);
            }
            if (files.length == 0) {
                inputFiles = dir.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File f) {
                        return !f.isHidden() && f.isFile();
                    }
                });
            }
        } else {
            directory = System.getProperty("user.dir");
        }
        if (inputFiles == null) {
            inputFiles = new File[files.length];
            for (int i = 0; i < files.length; ++i) {
                File f = new File(files[i]);
                boolean exists = false;
                exists = f.exists();
                if (!exists) {
                    f = new File(directory, files[i]);
                    exists = f.exists();
                }
                if (!exists) {
                    System.out.println("Input file " + files[i] + " does not exist.");
                    System.exit(1);
                }
                inputFiles[i] = f;
            }
        }
        return inputFiles;
    }
}

