/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.util;

import edu.rit.util.Logger;
import java.io.PrintStream;
import java.util.Date;

public class PrintStreamLogger
implements Logger {
    private PrintStream out;

    public PrintStreamLogger() {
        this.out = System.err;
    }

    public PrintStreamLogger(PrintStream printStream) {
        if (printStream == null) {
            throw new NullPointerException("PrintStreamLogger(): Print stream is null");
        }
        this.out = printStream;
    }

    public void log(String string) {
        this.log(System.currentTimeMillis(), string, null);
    }

    public void log(Throwable throwable) {
        this.log(System.currentTimeMillis(), null, throwable);
    }

    public void log(String string, Throwable throwable) {
        this.log(System.currentTimeMillis(), string, throwable);
    }

    public void log(long l, String string) {
        this.log(l, string, null);
    }

    public void log(long l, Throwable throwable) {
        this.log(l, null, throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(long l, String string, Throwable throwable) {
        PrintStream printStream = this.out;
        synchronized (printStream) {
            this.out.print(new Date(l));
            if (string != null) {
                this.out.print(' ');
                this.out.print(string);
            }
            this.out.println();
            if (throwable != null) {
                throwable.printStackTrace(this.out);
            }
        }
    }
}

