/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.smp.keysearch;

import edu.rit.crypto.blockcipher.AES256Cipher;
import edu.rit.pj.IntegerForLoop;
import edu.rit.pj.ParallelRegion;
import edu.rit.pj.ParallelTeam;
import edu.rit.util.Hex;

public class FindKeySmp2 {
    static byte[] plaintext;
    static byte[] ciphertext;
    static byte[] partialkey;
    static int n;
    static int keylsbs;
    static int maxcounter;
    static byte[] foundkey;

    private FindKeySmp2() {
    }

    public static void main(String[] stringArray) throws Exception {
        long l = System.currentTimeMillis();
        if (stringArray.length != 4) {
            FindKeySmp2.usage();
        }
        plaintext = Hex.toByteArray(stringArray[0]);
        ciphertext = Hex.toByteArray(stringArray[1]);
        partialkey = Hex.toByteArray(stringArray[2]);
        n = Integer.parseInt(stringArray[3]);
        if (n < 0) {
            System.err.println("n = " + n + " is too small");
            System.exit(1);
        }
        if (n > 30) {
            System.err.println("n = " + n + " is too large");
            System.exit(1);
        }
        keylsbs = (partialkey[28] & 0xFF) << 24 | (partialkey[29] & 0xFF) << 16 | (partialkey[30] & 0xFF) << 8 | partialkey[31] & 0xFF;
        maxcounter = (1 << n) - 1;
        new ParallelTeam().execute(new ParallelRegion(){

            public void run() throws Exception {
                this.execute(0, maxcounter, new IntegerForLoop(){
                    byte[] trialkey;
                    byte[] trialciphertext;
                    AES256Cipher cipher;

                    public void start() {
                        this.trialkey = new byte[32];
                        System.arraycopy(partialkey, 0, this.trialkey, 0, 32);
                        this.trialciphertext = new byte[16];
                        this.cipher = new AES256Cipher(this.trialkey);
                    }

                    public void run(int n, int n2) {
                        for (int i = n; i <= n2 && foundkey == null; ++i) {
                            int n3 = keylsbs | i;
                            this.trialkey[28] = (byte)(n3 >>> 24);
                            this.trialkey[29] = (byte)(n3 >>> 16);
                            this.trialkey[30] = (byte)(n3 >>> 8);
                            this.trialkey[31] = (byte)n3;
                            this.cipher.setKey(this.trialkey);
                            this.cipher.encrypt(plaintext, this.trialciphertext);
                            if (!FindKeySmp2.match(ciphertext, this.trialciphertext)) continue;
                            byte[] byArray = new byte[32];
                            System.arraycopy(this.trialkey, 0, byArray, 0, 32);
                            foundkey = byArray;
                        }
                    }
                });
            }
        });
        long l2 = System.currentTimeMillis();
        System.out.println(Hex.toString(foundkey));
        System.out.println(l2 - l + " msec");
    }

    private static boolean match(byte[] byArray, byte[] byArray2) {
        boolean bl = true;
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            bl = bl && byArray[i] == byArray2[i];
        }
        return bl;
    }

    private static void usage() {
        System.err.println("Usage: java [-Dpj.nt=<K>] edu.rit.smp.keysearch.FindKeySmp2 <plaintext> <ciphertext> <partialkey> <n>");
        System.err.println("<K> = Number of parallel threads");
        System.err.println("<plaintext> = Plaintext (128-bit hexadecimal number)");
        System.err.println("<ciphertext> = Ciphertext (128-bit hexadecimal number)");
        System.err.println("<partialkey> = Partial key (256-bit hexadecimal number)");
        System.err.println("<n> = Number of key bits to search for");
        System.exit(1);
    }
}

