/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.test;

import edu.rit.pj.Comm;
import edu.rit.pj.HybridTeam;
import edu.rit.pj.WorkerIntegerForLoop;
import edu.rit.pj.WorkerIntegerStrideForLoop;
import edu.rit.pj.WorkerRegion;

public class Test23 {
    private Test23() {
    }

    public static void main(String[] stringArray) throws Throwable {
        Comm.init(stringArray);
        if (stringArray.length != 3) {
            Test23.usage();
        }
        final int n = Integer.parseInt(stringArray[0]);
        final int n2 = Integer.parseInt(stringArray[1]);
        final int n3 = Integer.parseInt(stringArray[2]);
        new HybridTeam().execute(new WorkerRegion(){

            public void run() throws Exception {
                final int n4 = this.getThreadIndex();
                System.out.printf("Begin thread %d, rank %d%n", n4, Comm.world().rank());
                if (n3 == 1) {
                    this.execute(n, n2, new WorkerIntegerForLoop(){

                        public void run(int n, int n2) {
                            for (int i = n; i <= n2; ++i) {
                                System.out.printf("i = %d, thread = %d%n", i, n4);
                            }
                        }
                    });
                } else {
                    this.execute(n, n2, n3, new WorkerIntegerStrideForLoop(){

                        public void run(int n, int n2, int n3) {
                            for (int i = n; i <= n2; i += n3) {
                                System.out.printf("i = %d, thread = %d%n", i, n4);
                            }
                        }
                    });
                }
                System.out.printf("End thread %d%n", n4);
            }
        });
    }

    private static void usage() {
        System.err.println("Usage: java [-Dpj.np=<Kp>] [-Dpj.nt=<Kt>] [-Dpj.schedule=<schedule>] edu.rit.pj.test.Test23 <lb> <ub> <stride>");
        System.err.println("<Kp> = Number of parallel processes");
        System.err.println("<Kt> = Number of worker threads per process");
        System.err.println("<schedule> = Worker for loop schedule");
        System.err.println("<lb> = Loop index lower bound, inclusive");
        System.err.println("<ub> = Loop index upper bound, inclusive");
        System.err.println("<stride> = Loop stride");
        System.exit(1);
    }
}

