/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.replica;

import edu.rit.mp.ObjectBuf;
import edu.rit.mp.buf.ObjectItemBuf;
import edu.rit.pj.Comm;
import edu.rit.pj.reduction.ObjectOp;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplicatedObject<T> {
    private ObjectOp<T> myOp;
    private AtomicReference<T> myValue;
    private int myTag;
    private Comm myComm;
    private Receiver myReceiver;

    public ReplicatedObject(ObjectOp<T> objectOp) {
        this(objectOp, null, 0, Comm.world());
    }

    public ReplicatedObject(ObjectOp<T> objectOp, T t) {
        this(objectOp, t, 0, Comm.world());
    }

    public ReplicatedObject(ObjectOp<T> objectOp, T t, int n) {
        this(objectOp, t, n, Comm.world());
    }

    public ReplicatedObject(ObjectOp<T> objectOp, T t, int n, Comm comm) {
        if (objectOp == null) {
            throw new NullPointerException("ReplicatedObject(): op is null");
        }
        if (comm == null) {
            throw new NullPointerException("ReplicatedObject(): comm is null");
        }
        this.myOp = objectOp;
        this.myValue = new AtomicReference<T>(t);
        this.myTag = n;
        this.myComm = comm;
        this.myReceiver = new Receiver();
        this.myReceiver.setDaemon(true);
        this.myReceiver.start();
    }

    public T get() {
        return this.myValue.get();
    }

    public T reduce(T t) throws IOException {
        T t2;
        T t3;
        while (!this.myValue.compareAndSet(t3 = this.myValue.get(), t2 = this.myOp.op(t3, t))) {
        }
        if (t2 != t3) {
            this.myComm.floodSend(this.myTag, ObjectBuf.buffer(t2));
        }
        return t2;
    }

    public String toString() {
        return this.myValue.toString();
    }

    private class Receiver
    extends Thread {
        private Receiver() {
        }

        public void run() {
            ObjectItemBuf objectItemBuf = ObjectBuf.buffer();
            try {
                while (true) {
                    Object v;
                    Object v2;
                    ReplicatedObject.this.myComm.floodReceive(ReplicatedObject.this.myTag, objectItemBuf);
                    do {
                        v2 = ReplicatedObject.this.myValue.get();
                        v = ReplicatedObject.this.myOp.op(v2, objectItemBuf.item);
                    } while (!ReplicatedObject.this.myValue.compareAndSet(v2, v));
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace(System.err);
                return;
            }
        }
    }
}

