/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.replica;

import edu.rit.mp.IntegerBuf;
import edu.rit.mp.buf.IntegerItemBuf;
import edu.rit.pj.Comm;
import edu.rit.pj.reduction.IntegerOp;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;

public class ReplicatedInteger
extends Number {
    private IntegerOp myOp;
    private AtomicInteger myValue;
    private int myTag;
    private Comm myComm;
    private Receiver myReceiver;

    public ReplicatedInteger(IntegerOp integerOp) {
        this(integerOp, 0, 0, Comm.world());
    }

    public ReplicatedInteger(IntegerOp integerOp, int n) {
        this(integerOp, n, 0, Comm.world());
    }

    public ReplicatedInteger(IntegerOp integerOp, int n, int n2) {
        this(integerOp, n, n2, Comm.world());
    }

    public ReplicatedInteger(IntegerOp integerOp, int n, int n2, Comm comm) {
        if (integerOp == null) {
            throw new NullPointerException("ReplicatedInteger(): op is null");
        }
        if (comm == null) {
            throw new NullPointerException("ReplicatedInteger(): comm is null");
        }
        this.myOp = integerOp;
        this.myValue = new AtomicInteger(n);
        this.myTag = n2;
        this.myComm = comm;
        this.myReceiver = new Receiver();
        this.myReceiver.setDaemon(true);
        this.myReceiver.start();
    }

    public int get() {
        return this.myValue.get();
    }

    public int reduce(int n) throws IOException {
        int n2;
        int n3;
        while (!this.myValue.compareAndSet(n3 = this.myValue.get(), n2 = this.myOp.op(n3, n))) {
        }
        if (n2 != n3) {
            this.myComm.floodSend(this.myTag, IntegerBuf.buffer(n2));
        }
        return n2;
    }

    public String toString() {
        return Integer.toString(this.get());
    }

    public int intValue() {
        return this.get();
    }

    public long longValue() {
        return this.get();
    }

    public float floatValue() {
        return this.get();
    }

    public double doubleValue() {
        return this.get();
    }

    private class Receiver
    extends Thread {
        private Receiver() {
        }

        public void run() {
            IntegerItemBuf integerItemBuf = IntegerBuf.buffer();
            try {
                while (true) {
                    int n;
                    int n2;
                    ReplicatedInteger.this.myComm.floodReceive(ReplicatedInteger.this.myTag, integerItemBuf);
                    do {
                        n2 = ReplicatedInteger.this.myValue.get();
                        n = ReplicatedInteger.this.myOp.op(n2, integerItemBuf.item);
                    } while (!ReplicatedInteger.this.myValue.compareAndSet(n2, n));
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace(System.err);
                return;
            }
        }
    }
}

