/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.replica;

import edu.rit.mp.DoubleBuf;
import edu.rit.mp.buf.DoubleItemBuf;
import edu.rit.pj.Comm;
import edu.rit.pj.reduction.DoubleOp;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;

public class ReplicatedDouble
extends Number {
    private DoubleOp myOp;
    private AtomicLong myValue;
    private int myTag;
    private Comm myComm;
    private Receiver myReceiver;

    public ReplicatedDouble(DoubleOp doubleOp) {
        this(doubleOp, 0.0, 0, Comm.world());
    }

    public ReplicatedDouble(DoubleOp doubleOp, double d) {
        this(doubleOp, d, 0, Comm.world());
    }

    public ReplicatedDouble(DoubleOp doubleOp, double d, int n) {
        this(doubleOp, d, n, Comm.world());
    }

    public ReplicatedDouble(DoubleOp doubleOp, double d, int n, Comm comm) {
        if (doubleOp == null) {
            throw new NullPointerException("ReplicatedDouble(): op is null");
        }
        if (comm == null) {
            throw new NullPointerException("ReplicatedDouble(): comm is null");
        }
        this.myOp = doubleOp;
        this.myValue = new AtomicLong(Double.doubleToLongBits(d));
        this.myTag = n;
        this.myComm = comm;
        this.myReceiver = new Receiver();
        this.myReceiver.setDaemon(true);
        this.myReceiver.start();
    }

    public double get() {
        return Double.longBitsToDouble(this.myValue.get());
    }

    public double reduce(double d) throws IOException {
        double d2;
        double d3;
        long l;
        long l2;
        while (!this.myValue.compareAndSet(l2 = this.myValue.get(), l = Double.doubleToLongBits(d3 = this.myOp.op(d2 = Double.longBitsToDouble(l2), d)))) {
        }
        if (d3 != d2) {
            this.myComm.floodSend(this.myTag, DoubleBuf.buffer(d3));
        }
        return d3;
    }

    public String toString() {
        return Double.toString(this.get());
    }

    public int intValue() {
        return (int)this.get();
    }

    public long longValue() {
        return (long)this.get();
    }

    public float floatValue() {
        return (float)this.get();
    }

    public double doubleValue() {
        return this.get();
    }

    private class Receiver
    extends Thread {
        private Receiver() {
        }

        public void run() {
            DoubleItemBuf doubleItemBuf = DoubleBuf.buffer();
            try {
                while (true) {
                    long l;
                    long l2;
                    ReplicatedDouble.this.myComm.floodReceive(ReplicatedDouble.this.myTag, doubleItemBuf);
                    do {
                        l2 = ReplicatedDouble.this.myValue.get();
                        double d = Double.longBitsToDouble(l2);
                        double d2 = ReplicatedDouble.this.myOp.op(d, doubleItemBuf.item);
                        l = Double.doubleToLongBits(d2);
                    } while (!ReplicatedDouble.this.myValue.compareAndSet(l2, l));
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace(System.err);
                return;
            }
        }
    }
}

