/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj;

import edu.rit.mp.ObjectBuf;
import edu.rit.mp.buf.ObjectItemBuf;
import edu.rit.pj.Comm;
import edu.rit.pj.CommStatus;
import edu.rit.pj.ItemGenerator;
import edu.rit.pj.ItemHolder;
import edu.rit.pj.WorkerConstruct;
import edu.rit.pj.WorkerTeam;
import edu.rit.util.Range;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WorkerIteration<T>
extends WorkerConstruct {
    public void start() throws Exception {
    }

    public void sendTaskInput(T t, Comm comm, int n, int n2) throws IOException {
    }

    public void receiveTaskInput(T t, Comm comm, int n, int n2) throws IOException {
    }

    public abstract void run(T var1) throws Exception;

    public void sendTaskOutput(T t, Comm comm, int n, int n2) throws IOException {
    }

    public void receiveTaskOutput(T t, Comm comm, int n, int n2) throws IOException {
    }

    public void finish() throws Exception {
    }

    public int tagOffset() {
        return Integer.MIN_VALUE;
    }

    void masterExecute(ItemGenerator<T> itemGenerator) throws IOException {
        int n;
        int n2;
        ItemHolder<T> itemHolder;
        int n3;
        int n4 = n3 = this.myTeam.count;
        ObjectItemBuf objectItemBuf = ObjectBuf.buffer();
        Range range = new Range(this.tagFor(0), this.tagFor(n3 - 1));
        Comm comm = this.myTeam.comm;
        for (int i = 0; i < n3; ++i) {
            itemHolder = itemGenerator.nextItem();
            objectItemBuf.item = itemHolder;
            objectItemBuf.reset();
            n2 = this.myTeam.workerRank(i);
            n = this.tagFor(i);
            comm.send(n2, n, objectItemBuf);
            if (itemHolder == null) {
                --n4;
                continue;
            }
            this.sendTaskInput(itemHolder.myItem, comm, n2, n);
        }
        while (n4 > 0) {
            CommStatus commStatus = comm.receive(null, range, objectItemBuf);
            itemHolder = (ItemHolder<T>)objectItemBuf.item;
            n2 = commStatus.fromRank;
            n = commStatus.tag;
            int n5 = this.workerFor(n);
            this.receiveTaskOutput(itemHolder.myItem, comm, n2, n);
            itemHolder = itemGenerator.nextItem();
            objectItemBuf.item = itemHolder;
            objectItemBuf.reset();
            comm.send(n2, n, objectItemBuf);
            if (itemHolder == null) {
                --n4;
                continue;
            }
            this.sendTaskInput(itemHolder.myItem, comm, n2, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void workerExecute(int n) throws Exception {
        Comm comm = this.myTeam.comm;
        int n2 = this.myTeam.masterRank();
        int n3 = this.tagFor(n);
        this.start();
        ObjectItemBuf objectItemBuf = ObjectBuf.buffer();
        while (true) {
            comm.receive((Integer)n2, n3, objectItemBuf);
            ItemHolder itemHolder = (ItemHolder)objectItemBuf.item;
            if (itemHolder == null) break;
            this.receiveTaskInput(itemHolder.myItem, comm, n2, n3);
            this.run(itemHolder.myItem);
            objectItemBuf.reset();
            WorkerTeam workerTeam = this.myTeam;
            synchronized (workerTeam) {
                comm.send(n2, n3, objectItemBuf);
                this.sendTaskOutput(itemHolder.myItem, comm, n2, n3);
            }
        }
        this.finish();
    }

    private int tagFor(int n) {
        return n + this.tagOffset();
    }

    private int workerFor(int n) {
        return n - this.tagOffset();
    }
}

