/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj;

import edu.rit.pj.DynamicIntegerSchedule;
import edu.rit.pj.FixedIntegerSchedule;
import edu.rit.pj.GuidedIntegerSchedule;
import edu.rit.pj.PJProperties;
import edu.rit.pj.Schedule;
import edu.rit.util.Range;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public abstract class IntegerSchedule
extends Schedule {
    volatile int myOrderedIndex;

    protected IntegerSchedule() {
    }

    public static IntegerSchedule fixed() {
        return new FixedIntegerSchedule();
    }

    public static IntegerSchedule dynamic() {
        return new DynamicIntegerSchedule(1);
    }

    public static IntegerSchedule dynamic(int n) {
        return new DynamicIntegerSchedule(n);
    }

    public static IntegerSchedule guided() {
        return new GuidedIntegerSchedule(1);
    }

    public static IntegerSchedule guided(int n) {
        return new GuidedIntegerSchedule(n);
    }

    public static IntegerSchedule runtime() {
        return IntegerSchedule.runtime(IntegerSchedule.fixed());
    }

    public static IntegerSchedule runtime(IntegerSchedule integerSchedule) {
        String string = PJProperties.getPjSchedule();
        return string == null ? integerSchedule : IntegerSchedule.parse(string);
    }

    public static IntegerSchedule parse(String string) {
        try {
            int n = string.indexOf(40);
            if (n == -1) {
                Class<?> clazz = Class.forName(IntegerSchedule.getSubclassName(string), true, Thread.currentThread().getContextClassLoader());
                return (IntegerSchedule)clazz.newInstance();
            }
            int n2 = string.indexOf(41);
            if (n2 != string.length() - 1) {
                throw new IllegalArgumentException("IntegerSchedule.parse(): Schedule \"" + string + "\" illegal");
            }
            String[] stringArray = string.substring(n + 1, n2).split(",");
            Class<?> clazz = Class.forName(IntegerSchedule.getSubclassName(string.substring(0, n)), true, Thread.currentThread().getContextClassLoader());
            Constructor<?> constructor = clazz.getConstructor(String[].class);
            return (IntegerSchedule)constructor.newInstance(new Object[]{stringArray});
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException("IntegerSchedule.parse(): Schedule \"" + string + "\" illegal", classCastException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException("IntegerSchedule.parse(): Schedule \"" + string + "\" illegal", classNotFoundException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException("IntegerSchedule.parse(): Schedule \"" + string + "\" illegal", illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalArgumentException("IntegerSchedule.parse(): Schedule \"" + string + "\" illegal", instantiationException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new IllegalArgumentException("IntegerSchedule.parse(): Schedule \"" + string + "\" illegal", invocationTargetException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalArgumentException("IntegerSchedule.parse(): Schedule \"" + string + "\" illegal", noSuchMethodException);
        }
    }

    public abstract boolean isFixedSchedule();

    private static String getSubclassName(String string) {
        if (string.equals("fixed")) {
            return "edu.rit.pj.FixedIntegerSchedule";
        }
        if (string.equals("dynamic")) {
            return "edu.rit.pj.DynamicIntegerSchedule";
        }
        if (string.equals("guided")) {
            return "edu.rit.pj.GuidedIntegerSchedule";
        }
        return string;
    }

    void commonStart(int n, Range range) {
        this.myBreak = false;
        this.myOrderedIndex = range.lb();
        this.start(n, range);
    }

    public abstract void start(int var1, Range var2);

    Range commonNext(int n) {
        if (this.myBreak) {
            return null;
        }
        return this.next(n);
    }

    public abstract Range next(int var1);
}

