/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.numeric.plot.impl;

import edu.rit.numeric.plot.impl.NumericalAxis;
import edu.rit.numeric.plot.impl.Ticks;
import java.awt.Paint;
import java.awt.Stroke;

public class LogarithmicAxis
extends NumericalAxis {
    private int myStart;
    private int myEnd;
    private int myMin;
    private int myMax;
    private int myRange;
    private double myLengthOverMyRange;
    private int myMajorDivisionCount;
    private double myMajorDivisionRange;
    private int myMinorDivisionCount;
    private int myCrossing;
    private static final double LOG10 = Math.log(10.0);

    public LogarithmicAxis(int n, int n2, int n3, int n4, double d) {
        this(n, n2, n3, n4, d, DEFAULT_STROKE, DEFAULT_PAINT, null, null);
    }

    public LogarithmicAxis(int n, int n2, int n3, int n4, double d, Stroke stroke, Paint paint) {
        this(n, n2, n3, n4, d, stroke, paint, null, null);
    }

    public LogarithmicAxis(int n, int n2, int n3, int n4, double d, Ticks ticks, Ticks ticks2) {
        this(n, n2, n3, n4, d, DEFAULT_STROKE, DEFAULT_PAINT, ticks, ticks2);
    }

    public LogarithmicAxis(int n, int n2, int n3, int n4, double d, Stroke stroke, Paint paint, Ticks ticks, Ticks ticks2) {
        super(d, stroke, paint, ticks, ticks2);
        if (n == n2 || n3 < 1 || Math.min(n, n2) > n4 || n4 > Math.max(n, n2)) {
            throw new IllegalArgumentException();
        }
        this.myStart = n;
        this.myEnd = n2;
        this.myMin = Math.min(n, n2);
        this.myMax = Math.max(n, n2);
        this.myRange = n2 - n;
        this.myLengthOverMyRange = this.myLength / (double)this.myRange;
        this.myMajorDivisionCount = this.myMax - this.myMin;
        this.myMajorDivisionRange = this.myRange / this.myMajorDivisionCount;
        this.myMinorDivisionCount = n3;
        this.myCrossing = n4;
    }

    public double getStart() {
        return LogarithmicAxis.antilog10(this.myStart);
    }

    public double getEnd() {
        return LogarithmicAxis.antilog10(this.myEnd);
    }

    public boolean includesValue(double d) {
        double d2 = LogarithmicAxis.log10(d);
        return (double)this.myMin <= d2 && d2 <= (double)this.myMax;
    }

    public double getDisplayDistance(double d) {
        double d2 = LogarithmicAxis.log10(d);
        if (d2 == Double.NEGATIVE_INFINITY) {
            return -10.0 * this.myLengthOverMyRange;
        }
        return (d2 - (double)this.myStart) * this.myLengthOverMyRange;
    }

    public int getMajorDivisionCount() {
        return this.myMajorDivisionCount;
    }

    public double getMajorDivision(int n) {
        return LogarithmicAxis.antilog10((double)this.myStart + (double)n * this.myMajorDivisionRange);
    }

    public int getMinorDivisionCount() {
        return this.myMajorDivisionCount * this.myMinorDivisionCount;
    }

    public double getMinorDivision(int n) {
        int n2 = n / this.myMinorDivisionCount;
        int n3 = n % this.myMinorDivisionCount;
        double d = this.getMajorDivision(n2);
        return n3 == 0 ? d : 10.0 * d / (double)this.myMinorDivisionCount * (double)n3;
    }

    public double getCrossing() {
        return LogarithmicAxis.antilog10(this.myCrossing);
    }

    public static int[] autoscale(double d, double d2) {
        if (d <= 0.0 || d2 <= 0.0) {
            throw new IllegalArgumentException();
        }
        return new int[]{(int)Math.floor(LogarithmicAxis.log10(d)), (int)Math.ceil(LogarithmicAxis.log10(d2))};
    }

    private static double log10(double d) {
        return Math.log(d) / LOG10;
    }

    private static double antilog10(double d) {
        return Math.exp(d * LOG10);
    }
}

