/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.numeric.plot;

import edu.rit.numeric.ListXYSeries;
import edu.rit.numeric.XYSeries;
import edu.rit.numeric.plot.AxisDialog;
import edu.rit.numeric.plot.Dots;
import edu.rit.numeric.plot.PlotAreaDialog;
import edu.rit.numeric.plot.PlotFrame;
import edu.rit.numeric.plot.PlotMarginsDialog;
import edu.rit.numeric.plot.Strokes;
import edu.rit.numeric.plot.TitleDialog;
import edu.rit.numeric.plot.impl.Axis;
import edu.rit.numeric.plot.impl.Grid;
import edu.rit.numeric.plot.impl.Label;
import edu.rit.numeric.plot.impl.LinearAxis;
import edu.rit.numeric.plot.impl.LogarithmicAxis;
import edu.rit.numeric.plot.impl.NumericalAxis;
import edu.rit.numeric.plot.impl.PlotSeries;
import edu.rit.numeric.plot.impl.SegmentedPlotSeries;
import edu.rit.numeric.plot.impl.Ticks;
import edu.rit.numeric.plot.impl.XYPlot;
import edu.rit.numeric.plot.impl.XYPlotSeries;
import edu.rit.swing.DisplayableFrame;
import edu.rit.swing.Viewable;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Externalizable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Scanner;

public class Plot
implements Viewable,
Externalizable {
    public static final AxisKind LINEAR = AxisKind.LINEAR;
    public static final AxisKind LOGARITHMIC = AxisKind.LOGARITHMIC;
    public static final int ABOVE_LEFT = 0;
    public static final int ABOVE = 1;
    public static final int ABOVE_RIGHT = 2;
    public static final int LEFT = 3;
    public static final int CENTER = 4;
    public static final int RIGHT = 5;
    public static final int BELOW_LEFT = 6;
    public static final int BELOW = 7;
    public static final int BELOW_RIGHT = 8;
    public static final int ROTATE_LEFT = 9;
    public static final int ROTATE_RIGHT = 18;
    public static final int ROTATE_AROUND = 27;
    public static final int PIXEL_COORDINATES = 36;
    private static final long serialVersionUID = 5469967079348825097L;
    private static final Font thePlotFont = new Font("SansSerif", 1, 14);
    private static final Font theAxisFont = new Font("SansSerif", 0, 12);
    private static final BasicStroke theAxisStroke = Strokes.solid(0.6f);
    private static final BasicStroke theMajorGridLineStroke = Strokes.solid(0.2f);
    private static final BasicStroke theMinorGridLineStroke = Strokes.solid(0.1f);
    private String frameTitle = null;
    private String plotTitle = null;
    private Font plotTitleFont = thePlotFont;
    private double plotTitleOffset = 9.0;
    private double leftMargin = 54.0;
    private double topMargin = 27.0;
    private double rightMargin = 27.0;
    private double bottomMargin = 54.0;
    private boolean majorGridLines = true;
    private boolean minorGridLines = false;
    private AxisKind xAxisKind = LINEAR;
    private double xAxisStart = Double.NaN;
    private double xAxisEnd = Double.NaN;
    private int xAxisMajorDivisions = 10;
    private int xAxisMinorDivisions = 1;
    private double xAxisCrossing = Double.NaN;
    private double xAxisLength = 288.0;
    private DecimalFormat xAxisTickFormat = new DecimalFormat("0");
    private double xAxisTickScale = 1.0;
    private Font xAxisTickFont = theAxisFont;
    private String xAxisTitle = null;
    private Font xAxisTitleFont = theAxisFont;
    private double xAxisTitleOffset = 30.0;
    private AxisKind yAxisKind = LINEAR;
    private double yAxisStart = Double.NaN;
    private double yAxisEnd = Double.NaN;
    private int yAxisMajorDivisions = 10;
    private int yAxisMinorDivisions = 1;
    private double yAxisCrossing = Double.NaN;
    private double yAxisLength = 288.0;
    private DecimalFormat yAxisTickFormat = new DecimalFormat("0");
    private double yAxisTickScale = 1.0;
    private Font yAxisTickFont = theAxisFont;
    private String yAxisTitle = null;
    private Font yAxisTitleFont = theAxisFont;
    private double yAxisTitleOffset = 36.0;
    private Dots seriesDots = Dots.circle(5.0);
    private BasicStroke seriesStroke = Strokes.solid(2.0);
    private Color seriesColor = Color.black;
    private boolean seriesSmooth = false;
    private int labelPosition = 4;
    private double labelOffset = 0.0;
    private Font labelFont = theAxisFont;
    private Color labelColor = Color.black;
    private Color labelBackground = null;
    private ArrayList<PlotSeries> myPlotSeries = new ArrayList();
    private ArrayList<Label> myLabels = new ArrayList();
    private XYPlot myXYPlot;

    public Plot frameTitle(String string) {
        this.frameTitle = string;
        this.myXYPlot = null;
        return this;
    }

    public Plot plotTitle(String string) {
        this.plotTitle = string;
        this.myXYPlot = null;
        return this;
    }

    public Plot plotTitleFont(Font font) {
        this.plotTitleFont = font;
        this.myXYPlot = null;
        return this;
    }

    public Plot plotTitleOffset(double d) {
        this.plotTitleOffset = d;
        this.myXYPlot = null;
        return this;
    }

    public Plot margins(double d) {
        this.leftMargin = d;
        this.topMargin = d;
        this.rightMargin = d;
        this.bottomMargin = d;
        this.myXYPlot = null;
        return this;
    }

    public Plot leftMargin(double d) {
        this.leftMargin = d;
        this.myXYPlot = null;
        return this;
    }

    public Plot topMargin(double d) {
        this.topMargin = d;
        this.myXYPlot = null;
        return this;
    }

    public Plot rightMargin(double d) {
        this.rightMargin = d;
        this.myXYPlot = null;
        return this;
    }

    public Plot bottomMargin(double d) {
        this.bottomMargin = d;
        this.myXYPlot = null;
        return this;
    }

    public Plot majorGridLines(boolean bl) {
        this.majorGridLines = bl;
        this.myXYPlot = null;
        return this;
    }

    public Plot minorGridLines(boolean bl) {
        this.minorGridLines = bl;
        this.myXYPlot = null;
        return this;
    }

    public Plot xAxisKind(AxisKind axisKind) {
        this.xAxisKind = axisKind;
        this.myXYPlot = null;
        return this;
    }

    public Plot xAxisStart(double d) {
        this.xAxisStart = d;
        this.myXYPlot = null;
        return this;
    }

    public Plot xAxisEnd(double d) {
        this.xAxisEnd = d;
        this.myXYPlot = null;
        return this;
    }

    public Plot xAxisMajorDivisions(int n) {
        this.xAxisMajorDivisions = n;
        this.myXYPlot = null;
        return this;
    }

    public Plot xAxisMinorDivisions(int n) {
        this.xAxisMinorDivisions = n;
        this.myXYPlot = null;
        return this;
    }

    public Plot xAxisCrossing(double d) {
        this.xAxisCrossing = d;
        this.myXYPlot = null;
        return this;
    }

    public Plot xAxisLength(double d) {
        this.xAxisLength = d;
        this.myXYPlot = null;
        return this;
    }

    public Plot xAxisTickFormat(DecimalFormat decimalFormat) {
        this.xAxisTickFormat = decimalFormat;
        this.myXYPlot = null;
        return this;
    }

    public Plot xAxisTickScale(double d) {
        this.xAxisTickScale = d;
        this.myXYPlot = null;
        return this;
    }

    public Plot xAxisTickFont(Font font) {
        this.xAxisTickFont = font;
        this.myXYPlot = null;
        return this;
    }

    public Plot xAxisTitle(String string) {
        this.xAxisTitle = string;
        this.myXYPlot = null;
        return this;
    }

    public Plot xAxisTitleFont(Font font) {
        this.xAxisTitleFont = font;
        this.myXYPlot = null;
        return this;
    }

    public Plot xAxisTitleOffset(double d) {
        this.xAxisTitleOffset = d;
        this.myXYPlot = null;
        return this;
    }

    public Plot yAxisKind(AxisKind axisKind) {
        this.yAxisKind = axisKind;
        this.myXYPlot = null;
        return this;
    }

    public Plot yAxisStart(double d) {
        this.yAxisStart = d;
        this.myXYPlot = null;
        return this;
    }

    public Plot yAxisEnd(double d) {
        this.yAxisEnd = d;
        this.myXYPlot = null;
        return this;
    }

    public Plot yAxisMajorDivisions(int n) {
        this.yAxisMajorDivisions = n;
        this.myXYPlot = null;
        return this;
    }

    public Plot yAxisMinorDivisions(int n) {
        this.yAxisMinorDivisions = n;
        this.myXYPlot = null;
        return this;
    }

    public Plot yAxisCrossing(double d) {
        this.yAxisCrossing = d;
        this.myXYPlot = null;
        return this;
    }

    public Plot yAxisLength(double d) {
        this.yAxisLength = d;
        this.myXYPlot = null;
        return this;
    }

    public Plot yAxisTickFormat(DecimalFormat decimalFormat) {
        this.yAxisTickFormat = decimalFormat;
        this.myXYPlot = null;
        return this;
    }

    public Plot yAxisTickScale(double d) {
        this.yAxisTickScale = d;
        this.myXYPlot = null;
        return this;
    }

    public Plot yAxisTickFont(Font font) {
        this.yAxisTickFont = font;
        this.myXYPlot = null;
        return this;
    }

    public Plot yAxisTitle(String string) {
        this.yAxisTitle = string;
        this.myXYPlot = null;
        return this;
    }

    public Plot yAxisTitleFont(Font font) {
        this.yAxisTitleFont = font;
        this.myXYPlot = null;
        return this;
    }

    public Plot yAxisTitleOffset(double d) {
        this.yAxisTitleOffset = d;
        this.myXYPlot = null;
        return this;
    }

    public Plot seriesDots(Dots dots) {
        this.seriesDots = dots;
        return this;
    }

    public Plot seriesStroke(BasicStroke basicStroke) {
        this.seriesStroke = basicStroke;
        return this;
    }

    public Plot seriesColor(Color color) {
        this.seriesColor = color;
        return this;
    }

    public Plot seriesSmooth(boolean bl) {
        this.seriesSmooth = bl;
        return this;
    }

    public Plot xySeries(String string) throws FileNotFoundException {
        return this.xySeries(new Scanner(new File(string)));
    }

    public Plot xySeries(File file) throws FileNotFoundException {
        return this.xySeries(new Scanner(file));
    }

    public Plot xySeries(InputStream inputStream) {
        return this.xySeries(new Scanner(inputStream));
    }

    public Plot xySeries(Scanner scanner) {
        ListXYSeries listXYSeries = new ListXYSeries().add(scanner);
        scanner.close();
        return this.xySeries(listXYSeries);
    }

    public Plot xySeries(double ... dArray) {
        return this.xySeries(new ListXYSeries().add(dArray));
    }

    public Plot xySeries(double[] dArray, double[] dArray2) {
        return this.xySeries(new ListXYSeries().add(dArray, dArray2));
    }

    public Plot xySeries(XYSeries xYSeries) {
        this.myPlotSeries.add(new XYPlotSeries(xYSeries, this.seriesDots, this.seriesStroke, this.seriesColor, this.seriesSmooth));
        this.myXYPlot = null;
        return this;
    }

    public Plot segmentedSeries(String string) throws FileNotFoundException {
        return this.segmentedSeries(new Scanner(new File(string)));
    }

    public Plot segmentedSeries(File file) throws FileNotFoundException {
        return this.segmentedSeries(new Scanner(file));
    }

    public Plot segmentedSeries(InputStream inputStream) {
        return this.segmentedSeries(new Scanner(inputStream));
    }

    public Plot segmentedSeries(Scanner scanner) {
        ListXYSeries listXYSeries = new ListXYSeries().add(scanner);
        scanner.close();
        return this.segmentedSeries(listXYSeries);
    }

    public Plot segmentedSeries(double ... dArray) {
        return this.segmentedSeries(new ListXYSeries().add(dArray));
    }

    public Plot segmentedSeries(double[] dArray, double[] dArray2) {
        return this.segmentedSeries(new ListXYSeries().add(dArray, dArray2));
    }

    public Plot segmentedSeries(XYSeries xYSeries) {
        this.myPlotSeries.add(new SegmentedPlotSeries(xYSeries, this.seriesDots, this.seriesStroke, this.seriesColor));
        this.myXYPlot = null;
        return this;
    }

    public Plot labelPosition(int n) {
        this.labelPosition = n;
        return this;
    }

    public Plot labelOffset(double d) {
        this.labelOffset = d;
        return this;
    }

    public Plot labelFont(Font font) {
        this.labelFont = font;
        return this;
    }

    public Plot labelColor(Color color) {
        this.labelColor = color;
        return this;
    }

    public Plot labelBackground(Color color) {
        this.labelBackground = color;
        return this;
    }

    public Plot label(String string, double d, double d2) {
        this.myLabels.add(new Label(string, d, d2, this.labelPosition, this.labelOffset, this.labelFont, this.labelColor, this.labelBackground));
        this.myXYPlot = null;
        return this;
    }

    public void draw(Graphics2D graphics2D) {
        this.getXYPlot().draw(graphics2D);
    }

    public Rectangle2D getBoundingBox() {
        return this.getXYPlot().getBoundingBox();
    }

    public Paint getBackgroundPaint() {
        return this.getXYPlot().getBackgroundPaint();
    }

    public DisplayableFrame getFrame() {
        return new PlotFrame(this.getTitle(), this);
    }

    public String getTitle() {
        return this.frameTitle != null ? this.frameTitle : this.plotTitle;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.frameTitle);
        objectOutput.writeObject(this.plotTitle);
        objectOutput.writeObject(this.plotTitleFont);
        objectOutput.writeDouble(this.plotTitleOffset);
        objectOutput.writeDouble(this.leftMargin);
        objectOutput.writeDouble(this.topMargin);
        objectOutput.writeDouble(this.rightMargin);
        objectOutput.writeDouble(this.bottomMargin);
        objectOutput.writeBoolean(this.majorGridLines);
        objectOutput.writeBoolean(this.minorGridLines);
        objectOutput.writeObject((Object)this.xAxisKind);
        objectOutput.writeDouble(this.xAxisStart);
        objectOutput.writeDouble(this.xAxisEnd);
        objectOutput.writeInt(this.xAxisMajorDivisions);
        objectOutput.writeInt(this.xAxisMinorDivisions);
        objectOutput.writeDouble(this.xAxisCrossing);
        objectOutput.writeDouble(this.xAxisLength);
        objectOutput.writeObject(this.xAxisTickFormat);
        objectOutput.writeDouble(this.xAxisTickScale);
        objectOutput.writeObject(this.xAxisTickFont);
        objectOutput.writeObject(this.xAxisTitle);
        objectOutput.writeObject(this.xAxisTitleFont);
        objectOutput.writeDouble(this.xAxisTitleOffset);
        objectOutput.writeObject((Object)this.yAxisKind);
        objectOutput.writeDouble(this.yAxisStart);
        objectOutput.writeDouble(this.yAxisEnd);
        objectOutput.writeInt(this.yAxisMajorDivisions);
        objectOutput.writeInt(this.yAxisMinorDivisions);
        objectOutput.writeDouble(this.yAxisCrossing);
        objectOutput.writeDouble(this.yAxisLength);
        objectOutput.writeObject(this.yAxisTickFormat);
        objectOutput.writeDouble(this.yAxisTickScale);
        objectOutput.writeObject(this.yAxisTickFont);
        objectOutput.writeObject(this.yAxisTitle);
        objectOutput.writeObject(this.yAxisTitleFont);
        objectOutput.writeDouble(this.yAxisTitleOffset);
        objectOutput.writeObject(this.seriesDots);
        Strokes.writeExternal(this.seriesStroke, objectOutput);
        objectOutput.writeObject(this.seriesColor);
        objectOutput.writeBoolean(this.seriesSmooth);
        objectOutput.writeInt(this.labelPosition);
        objectOutput.writeDouble(this.labelOffset);
        objectOutput.writeObject(this.labelFont);
        objectOutput.writeObject(this.labelColor);
        objectOutput.writeObject(this.labelBackground);
        objectOutput.writeInt(this.myPlotSeries.size());
        for (PlotSeries externalizable : this.myPlotSeries) {
            objectOutput.writeObject(externalizable);
        }
        objectOutput.writeInt(this.myLabels.size());
        for (Label label : this.myLabels) {
            objectOutput.writeObject(label);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n;
        this.frameTitle = (String)objectInput.readObject();
        this.plotTitle = (String)objectInput.readObject();
        this.plotTitleFont = (Font)objectInput.readObject();
        this.plotTitleOffset = objectInput.readDouble();
        this.leftMargin = objectInput.readDouble();
        this.topMargin = objectInput.readDouble();
        this.rightMargin = objectInput.readDouble();
        this.bottomMargin = objectInput.readDouble();
        this.majorGridLines = objectInput.readBoolean();
        this.minorGridLines = objectInput.readBoolean();
        this.xAxisKind = (AxisKind)((Object)objectInput.readObject());
        this.xAxisStart = objectInput.readDouble();
        this.xAxisEnd = objectInput.readDouble();
        this.xAxisMajorDivisions = objectInput.readInt();
        this.xAxisMinorDivisions = objectInput.readInt();
        this.xAxisCrossing = objectInput.readDouble();
        this.xAxisLength = objectInput.readDouble();
        this.xAxisTickFormat = (DecimalFormat)objectInput.readObject();
        this.xAxisTickScale = objectInput.readDouble();
        this.xAxisTickFont = (Font)objectInput.readObject();
        this.xAxisTitle = (String)objectInput.readObject();
        this.xAxisTitleFont = (Font)objectInput.readObject();
        this.xAxisTitleOffset = objectInput.readDouble();
        this.yAxisKind = (AxisKind)((Object)objectInput.readObject());
        this.yAxisStart = objectInput.readDouble();
        this.yAxisEnd = objectInput.readDouble();
        this.yAxisMajorDivisions = objectInput.readInt();
        this.yAxisMinorDivisions = objectInput.readInt();
        this.yAxisCrossing = objectInput.readDouble();
        this.yAxisLength = objectInput.readDouble();
        this.yAxisTickFormat = (DecimalFormat)objectInput.readObject();
        this.yAxisTickScale = objectInput.readDouble();
        this.yAxisTickFont = (Font)objectInput.readObject();
        this.yAxisTitle = (String)objectInput.readObject();
        this.yAxisTitleFont = (Font)objectInput.readObject();
        this.yAxisTitleOffset = objectInput.readDouble();
        this.seriesDots = (Dots)objectInput.readObject();
        this.seriesStroke = Strokes.readExternal(objectInput);
        this.seriesColor = (Color)objectInput.readObject();
        this.seriesSmooth = objectInput.readBoolean();
        this.labelPosition = objectInput.readInt();
        this.labelOffset = objectInput.readDouble();
        this.labelFont = (Font)objectInput.readObject();
        this.labelColor = (Color)objectInput.readObject();
        this.labelBackground = (Color)objectInput.readObject();
        this.myPlotSeries.clear();
        int n2 = objectInput.readInt();
        for (n = 0; n < n2; ++n) {
            this.myPlotSeries.add((PlotSeries)objectInput.readObject());
        }
        this.myLabels.clear();
        n2 = objectInput.readInt();
        for (n = 0; n < n2; ++n) {
            this.myLabels.add((Label)objectInput.readObject());
        }
    }

    public static void write(Plot plot, String string) throws IOException {
        Plot.write(plot, new File(string));
    }

    public static void write(Plot plot, File file) throws IOException {
        FileOutputStream fileOutputStream = null;
        BufferedOutputStream bufferedOutputStream = null;
        ObjectOutputStream objectOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            objectOutputStream = new ObjectOutputStream(bufferedOutputStream);
            objectOutputStream.writeObject(plot);
            objectOutputStream.close();
        }
        catch (IOException iOException) {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
            }
            throw iOException;
        }
    }

    public static Plot read(String string) throws IOException, ClassNotFoundException {
        return Plot.read(new File(string));
    }

    public static Plot read(File file) throws IOException, ClassNotFoundException {
        FileInputStream fileInputStream = null;
        BufferedInputStream bufferedInputStream = null;
        ObjectInputStream objectInputStream = null;
        Plot plot = null;
        try {
            fileInputStream = new FileInputStream(file);
            bufferedInputStream = new BufferedInputStream(fileInputStream);
            objectInputStream = new ObjectInputStream(bufferedInputStream);
            plot = (Plot)objectInputStream.readObject();
            objectInputStream.close();
            return plot;
        }
        catch (IOException iOException) {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
            }
            throw iOException;
        }
    }

    private XYPlot getXYPlot() {
        Object object;
        Object object2;
        if (this.myXYPlot != null) {
            return this.myXYPlot;
        }
        Grid grid = new Grid(this.majorGridLines ? theMajorGridLineStroke : null, Axis.DEFAULT_PAINT, this.minorGridLines ? theMinorGridLineStroke : null, Axis.DEFAULT_PAINT);
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        double d3 = Double.POSITIVE_INFINITY;
        double d4 = Double.NEGATIVE_INFINITY;
        for (PlotSeries plotSeries : this.myPlotSeries) {
            XYSeries xYSeries = plotSeries.getDataSeries();
            d = Math.min(d, xYSeries.minX());
            d2 = Math.max(d2, xYSeries.maxX());
            d3 = Math.min(d3, xYSeries.minY());
            d4 = Math.max(d4, xYSeries.maxY());
        }
        Object object3 = null;
        double d5 = 0.0;
        Ticks ticks = new Ticks(theAxisStroke, Axis.DEFAULT_PAINT, 4.0, this.xAxisTickFormat, this.xAxisTickScale, this.xAxisTickFont, Axis.DEFAULT_PAINT, 4.0);
        switch (this.xAxisKind) {
            case LINEAR: {
                d = Double.isNaN(this.xAxisStart) ? (d < 0.0 ? LinearAxis.autoscale(d) : 0.0) : this.xAxisStart;
                d2 = Double.isNaN(this.xAxisEnd) ? (d2 > 0.0 ? LinearAxis.autoscale(d2) : 0.0) : this.xAxisEnd;
                d5 = Double.isNaN(this.xAxisCrossing) ? d : this.xAxisCrossing;
                object3 = new LinearAxis(d, d2, this.xAxisMajorDivisions, this.xAxisMinorDivisions, d5, this.xAxisLength, theAxisStroke, Axis.DEFAULT_PAINT, ticks, null);
                break;
            }
            case LOGARITHMIC: {
                object2 = null;
                if (Double.isNaN(this.xAxisStart) || Double.isNaN(this.xAxisEnd)) {
                    object2 = LogarithmicAxis.autoscale(d, d2);
                }
                d = Double.isNaN(this.xAxisStart) ? (double)object2[0] : this.xAxisStart;
                d2 = Double.isNaN(this.xAxisEnd) ? (double)object2[1] : this.xAxisEnd;
                d5 = Double.isNaN(this.xAxisCrossing) ? d : this.xAxisCrossing;
                object3 = new LogarithmicAxis((int)d, (int)d2, this.xAxisMinorDivisions, (int)d5, this.xAxisLength, theAxisStroke, Axis.DEFAULT_PAINT, ticks, null);
            }
        }
        object2 = null;
        double d6 = 0.0;
        Ticks ticks2 = new Ticks(theAxisStroke, Axis.DEFAULT_PAINT, 4.0, this.yAxisTickFormat, this.yAxisTickScale, this.yAxisTickFont, Axis.DEFAULT_PAINT, 4.0);
        switch (this.yAxisKind) {
            case LINEAR: {
                d3 = Double.isNaN(this.yAxisStart) ? (d3 < 0.0 ? LinearAxis.autoscale(d3) : 0.0) : this.yAxisStart;
                d4 = Double.isNaN(this.yAxisEnd) ? (d4 > 0.0 ? LinearAxis.autoscale(d4) : 0.0) : this.yAxisEnd;
                d6 = Double.isNaN(this.yAxisCrossing) ? d3 : this.yAxisCrossing;
                object2 = new LinearAxis(d3, d4, this.yAxisMajorDivisions, this.yAxisMinorDivisions, d6, this.yAxisLength, theAxisStroke, Axis.DEFAULT_PAINT, ticks2, null);
                break;
            }
            case LOGARITHMIC: {
                object = null;
                if (Double.isNaN(this.yAxisStart) || Double.isNaN(this.yAxisEnd)) {
                    object = LogarithmicAxis.autoscale(d3, d4);
                }
                d3 = Double.isNaN(this.yAxisStart) ? (double)object[0] : this.yAxisStart;
                d4 = Double.isNaN(this.yAxisEnd) ? (double)object[1] : this.yAxisEnd;
                d6 = Double.isNaN(this.yAxisCrossing) ? d3 : this.yAxisCrossing;
                object2 = new LogarithmicAxis((int)d3, (int)d4, this.yAxisMinorDivisions, (int)d6, this.yAxisLength, theAxisStroke, Axis.DEFAULT_PAINT, ticks2, null);
            }
        }
        object = new XYPlot((NumericalAxis)object3, (NumericalAxis)object2, grid, this.leftMargin, this.topMargin, this.rightMargin, this.bottomMargin);
        for (PlotSeries externalizable : this.myPlotSeries) {
            ((XYPlot)object).addPlotSeries(externalizable);
        }
        for (Label label : this.myLabels) {
            ((XYPlot)object).addLabel(label);
        }
        if (this.plotTitle != null) {
            ((XYPlot)object).addLabel(new Label(this.plotTitle, 0.5 * this.xAxisLength, this.yAxisLength, 37, this.plotTitleOffset, this.plotTitleFont));
        }
        if (this.xAxisTitle != null) {
            ((XYPlot)object).addLabel(new Label(this.xAxisTitle, 0.5 * this.xAxisLength, 0.0, 43, this.xAxisTitleOffset, this.xAxisTitleFont));
        }
        if (this.yAxisTitle != null) {
            ((XYPlot)object).addLabel(new Label(this.yAxisTitle, 0.0, 0.5 * this.yAxisLength, 48, this.yAxisTitleOffset, this.yAxisTitleFont));
        }
        this.myXYPlot = object;
        return object;
    }

    boolean formatPlotTitle(TitleDialog titleDialog) {
        titleDialog.setTitleText(this.plotTitle);
        titleDialog.setTitleFont(this.plotTitleFont);
        titleDialog.setTitleOffset(this.plotTitleOffset);
        titleDialog.setVisible(true);
        boolean bl = titleDialog.isOkay();
        if (bl) {
            this.plotTitle = titleDialog.getTitleText();
            this.plotTitleFont = titleDialog.getTitleFont();
            this.plotTitleOffset = titleDialog.getTitleOffset();
            this.myXYPlot = null;
        }
        return bl;
    }

    boolean formatPlotMargins(PlotMarginsDialog plotMarginsDialog) {
        plotMarginsDialog.setTopMargin(this.topMargin);
        plotMarginsDialog.setLeftMargin(this.leftMargin);
        plotMarginsDialog.setBottomMargin(this.bottomMargin);
        plotMarginsDialog.setRightMargin(this.rightMargin);
        plotMarginsDialog.setVisible(true);
        boolean bl = plotMarginsDialog.isOkay();
        if (bl) {
            this.topMargin = plotMarginsDialog.getTopMargin();
            this.leftMargin = plotMarginsDialog.getLeftMargin();
            this.bottomMargin = plotMarginsDialog.getBottomMargin();
            this.rightMargin = plotMarginsDialog.getRightMargin();
            this.myXYPlot = null;
        }
        return bl;
    }

    boolean formatPlotArea(PlotAreaDialog plotAreaDialog) {
        plotAreaDialog.setPlotAreaWidth(this.xAxisLength);
        plotAreaDialog.setPlotAreaHeight(this.yAxisLength);
        plotAreaDialog.setMajorGridLines(this.majorGridLines);
        plotAreaDialog.setMinorGridLines(this.minorGridLines);
        plotAreaDialog.setVisible(true);
        boolean bl = plotAreaDialog.isOkay();
        if (bl) {
            this.xAxisLength = plotAreaDialog.getPlotAreaWidth();
            this.yAxisLength = plotAreaDialog.getPlotAreaHeight();
            this.majorGridLines = plotAreaDialog.getMajorGridLines();
            this.minorGridLines = plotAreaDialog.getMinorGridLines();
            this.myXYPlot = null;
        }
        return bl;
    }

    boolean formatXAxis(AxisDialog axisDialog) {
        axisDialog.setAxisKind(this.xAxisKind);
        axisDialog.setAxisStart(this.xAxisStart);
        axisDialog.setAxisEnd(this.xAxisEnd);
        axisDialog.setAxisMajorDivisions(this.xAxisMajorDivisions);
        axisDialog.setAxisMinorDivisions(this.xAxisMinorDivisions);
        axisDialog.setAxisCrossing(this.xAxisCrossing);
        axisDialog.setTickFont(this.xAxisTickFont);
        axisDialog.setTickFormat(this.xAxisTickFormat);
        axisDialog.setTickScale(this.xAxisTickScale);
        axisDialog.setVisible(true);
        boolean bl = axisDialog.isOkay();
        if (bl) {
            this.xAxisKind = axisDialog.getAxisKind();
            this.xAxisStart = axisDialog.getAxisStart();
            this.xAxisEnd = axisDialog.getAxisEnd();
            this.xAxisMajorDivisions = axisDialog.getAxisMajorDivisions();
            this.xAxisMinorDivisions = axisDialog.getAxisMinorDivisions();
            this.xAxisCrossing = axisDialog.getAxisCrossing();
            this.xAxisTickFont = axisDialog.getTickFont();
            this.xAxisTickFormat = axisDialog.getTickFormat();
            this.xAxisTickScale = axisDialog.getTickScale();
            this.myXYPlot = null;
        }
        return bl;
    }

    boolean formatXAxisTitle(TitleDialog titleDialog) {
        titleDialog.setTitleText(this.xAxisTitle);
        titleDialog.setTitleFont(this.xAxisTitleFont);
        titleDialog.setTitleOffset(this.xAxisTitleOffset);
        titleDialog.setVisible(true);
        boolean bl = titleDialog.isOkay();
        if (bl) {
            this.xAxisTitle = titleDialog.getTitleText();
            this.xAxisTitleFont = titleDialog.getTitleFont();
            this.xAxisTitleOffset = titleDialog.getTitleOffset();
            this.myXYPlot = null;
        }
        return bl;
    }

    boolean formatYAxis(AxisDialog axisDialog) {
        axisDialog.setAxisKind(this.yAxisKind);
        axisDialog.setAxisStart(this.yAxisStart);
        axisDialog.setAxisEnd(this.yAxisEnd);
        axisDialog.setAxisMajorDivisions(this.yAxisMajorDivisions);
        axisDialog.setAxisMinorDivisions(this.yAxisMinorDivisions);
        axisDialog.setAxisCrossing(this.yAxisCrossing);
        axisDialog.setTickFont(this.yAxisTickFont);
        axisDialog.setTickFormat(this.yAxisTickFormat);
        axisDialog.setTickScale(this.yAxisTickScale);
        axisDialog.setVisible(true);
        boolean bl = axisDialog.isOkay();
        if (bl) {
            this.yAxisKind = axisDialog.getAxisKind();
            this.yAxisStart = axisDialog.getAxisStart();
            this.yAxisEnd = axisDialog.getAxisEnd();
            this.yAxisMajorDivisions = axisDialog.getAxisMajorDivisions();
            this.yAxisMinorDivisions = axisDialog.getAxisMinorDivisions();
            this.yAxisCrossing = axisDialog.getAxisCrossing();
            this.yAxisTickFont = axisDialog.getTickFont();
            this.yAxisTickFormat = axisDialog.getTickFormat();
            this.yAxisTickScale = axisDialog.getTickScale();
            this.myXYPlot = null;
        }
        return bl;
    }

    boolean formatYAxisTitle(TitleDialog titleDialog) {
        titleDialog.setTitleText(this.yAxisTitle);
        titleDialog.setTitleFont(this.yAxisTitleFont);
        titleDialog.setTitleOffset(this.yAxisTitleOffset);
        titleDialog.setVisible(true);
        boolean bl = titleDialog.isOkay();
        if (bl) {
            this.yAxisTitle = titleDialog.getTitleText();
            this.yAxisTitleFont = titleDialog.getTitleFont();
            this.yAxisTitleOffset = titleDialog.getTitleOffset();
            this.myXYPlot = null;
        }
        return bl;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AxisKind {
        LINEAR,
        LOGARITHMIC;

    }
}

