/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.numeric;

import edu.rit.numeric.XYZSeries;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Scanner;

public class ListXYZSeries
extends XYZSeries
implements Externalizable {
    private static final long serialVersionUID = -6171759304132178882L;
    private static final int INCR = 16;
    private double[] xArray = new double[16];
    private double[] yArray = new double[16];
    private double[] zArray = new double[16];
    private int myLength = 0;

    public int length() {
        return this.myLength;
    }

    public double x(int n) {
        if (0 > n || n >= this.myLength) {
            throw new ArrayIndexOutOfBoundsException("ListXYZSeries.x(): Index = " + n + " out of bounds");
        }
        return this.xArray[n];
    }

    public double y(int n) {
        if (0 > n || n >= this.myLength) {
            throw new ArrayIndexOutOfBoundsException("ListXYZSeries.y(): Index = " + n + " out of bounds");
        }
        return this.yArray[n];
    }

    public double z(int n) {
        if (0 > n || n >= this.myLength) {
            throw new ArrayIndexOutOfBoundsException("ListXYZSeries.z(): Index = " + n + " out of bounds");
        }
        return this.zArray[n];
    }

    public ListXYZSeries clear() {
        this.myLength = 0;
        return this;
    }

    public ListXYZSeries add(double d, double d2, double d3) {
        this.allocate(1, 16);
        this.xArray[this.myLength] = d;
        this.yArray[this.myLength] = d2;
        this.zArray[this.myLength] = d3;
        ++this.myLength;
        return this;
    }

    public ListXYZSeries add(double ... dArray) {
        int n = dArray.length / 3;
        this.allocate(n, n);
        for (int i = 0; i < n; ++i) {
            this.xArray[this.myLength] = dArray[3 * i];
            this.yArray[this.myLength] = dArray[3 * i + 1];
            this.zArray[this.myLength] = dArray[3 * i + 2];
            ++this.myLength;
        }
        return this;
    }

    public ListXYZSeries add(double[] dArray, double[] dArray2, double[] dArray3) {
        return this.add(dArray, dArray2, dArray3, 0, dArray.length);
    }

    public ListXYZSeries add(double[] dArray, double[] dArray2, double[] dArray3, int n, int n2) {
        if (n < 0 || n2 < 0 || n + n2 > dArray.length || n + n2 > dArray2.length || n + n2 > dArray3.length) {
            throw new IndexOutOfBoundsException();
        }
        if (this.myLength + n2 > this.xArray.length) {
            double[] dArray4 = new double[this.myLength + n2];
            System.arraycopy(this.xArray, 0, dArray4, 0, this.myLength);
            this.xArray = dArray4;
            double[] dArray5 = new double[this.myLength + n2];
            System.arraycopy(this.yArray, 0, dArray5, 0, this.myLength);
            this.yArray = dArray5;
            double[] dArray6 = new double[this.myLength + n2];
            System.arraycopy(this.zArray, 0, dArray6, 0, this.myLength);
            this.zArray = dArray6;
        }
        System.arraycopy(dArray, n, this.xArray, this.myLength, n2);
        System.arraycopy(dArray2, n, this.yArray, this.myLength, n2);
        System.arraycopy(dArray3, n, this.zArray, this.myLength, n2);
        this.myLength += n2;
        return this;
    }

    public ListXYZSeries add(XYZSeries xYZSeries) {
        return this.add(xYZSeries, 0, xYZSeries.length());
    }

    public ListXYZSeries add(XYZSeries xYZSeries, int n, int n2) {
        if (n < 0 || n2 < 0 || n + n2 > xYZSeries.length()) {
            throw new IndexOutOfBoundsException();
        }
        this.allocate(n2, n2);
        while (n2 > 0) {
            this.xArray[this.myLength] = xYZSeries.x(n);
            this.yArray[this.myLength] = xYZSeries.y(n);
            this.zArray[this.myLength] = xYZSeries.z(n);
            ++this.myLength;
            ++n;
            --n2;
        }
        return this;
    }

    public ListXYZSeries add(Scanner scanner) {
        while (scanner.hasNextDouble()) {
            double d = scanner.nextDouble();
            if (!scanner.hasNextDouble()) continue;
            double d2 = scanner.nextDouble();
            if (!scanner.hasNextDouble()) continue;
            double d3 = scanner.nextDouble();
            this.add(d, d2, d3);
        }
        return this;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n = this.myLength;
        objectOutput.writeInt(n);
        for (int i = 0; i < n; ++i) {
            objectOutput.writeDouble(this.xArray[i]);
            objectOutput.writeDouble(this.yArray[i]);
            objectOutput.writeDouble(this.zArray[i]);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException {
        int n = objectInput.readInt();
        this.xArray = new double[n];
        this.yArray = new double[n];
        this.zArray = new double[n];
        this.myLength = n;
        for (int i = 0; i < n; ++i) {
            this.xArray[i] = objectInput.readDouble();
            this.yArray[i] = objectInput.readDouble();
            this.zArray[i] = objectInput.readDouble();
        }
    }

    private void allocate(int n, int n2) {
        if (this.myLength + n > this.xArray.length) {
            double[] dArray = new double[this.myLength + n2];
            System.arraycopy(this.xArray, 0, dArray, 0, this.myLength);
            this.xArray = dArray;
            double[] dArray2 = new double[this.myLength + n2];
            System.arraycopy(this.yArray, 0, dArray2, 0, this.myLength);
            this.yArray = dArray2;
            double[] dArray3 = new double[this.myLength + n2];
            System.arraycopy(this.zArray, 0, dArray3, 0, this.myLength);
            this.zArray = dArray3;
        }
    }
}

