/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.numeric;

import edu.rit.numeric.Series;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class ArraySeries
extends Series
implements Externalizable {
    private static final long serialVersionUID = 5850541176666797722L;
    private double[] xarray;

    public ArraySeries() {
    }

    public ArraySeries(double[] dArray) {
        if (dArray == null) {
            throw new NullPointerException("ArraySeries(): xarray is null");
        }
        this.xarray = dArray;
    }

    public int length() {
        return this.xarray.length;
    }

    public double x(int n) {
        return this.xarray[n];
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n = this.xarray.length;
        objectOutput.writeInt(n);
        for (int i = 0; i < n; ++i) {
            objectOutput.writeDouble(this.xarray[i]);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException {
        int n = objectInput.readInt();
        this.xarray = new double[n];
        for (int i = 0; i < n; ++i) {
            this.xarray[i] = objectInput.readDouble();
        }
    }
}

