/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mri.test;

import edu.rit.numeric.ListXYSeries;
import edu.rit.numeric.plot.Dots;
import edu.rit.numeric.plot.Plot;
import edu.rit.numeric.plot.Strokes;
import java.awt.Color;
import java.io.File;
import java.util.Scanner;

public class PlotData {
    private PlotData() {
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 1 || stringArray.length % 2 != 1) {
            PlotData.usage();
        }
        File file = new File(stringArray[0]);
        int n = (stringArray.length - 1) / 2;
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = Double.parseDouble(stringArray[2 * i + 1]);
            dArray2[i] = Double.parseDouble(stringArray[2 * i + 2]);
        }
        ListXYSeries listXYSeries = new ListXYSeries();
        listXYSeries.add(new Scanner(file));
        Plot plot = new Plot();
        plot.xAxisLength(1200.0).xAxisMajorDivisions(20).yAxisLength(600.0).yAxisMajorDivisions(10).seriesDots(Dots.circle(Color.BLACK, null, null, 5.0)).seriesColor(Color.BLACK).seriesStroke(Strokes.solid(2.0)).xySeries(listXYSeries);
        if (n > 0) {
            double d = 0.0;
            ListXYSeries listXYSeries2 = new ListXYSeries();
            for (int i = 0; i < listXYSeries.length(); ++i) {
                double d2 = listXYSeries.x(i);
                double d3 = 0.0;
                for (int j = 0; j < n; ++j) {
                    d3 += dArray[j] * (1.0 - 2.0 * Math.exp(-dArray2[j] * d2));
                }
                double d4 = d3 - listXYSeries.y(i);
                d += d4 * d4;
                listXYSeries2.add(d2, d3);
            }
            System.out.println("chi^2 = " + d);
            plot.seriesDots(null).seriesColor(Color.RED).seriesStroke(Strokes.solid(1.0)).xySeries(listXYSeries2);
        }
        plot.getFrame().setVisible(true);
    }

    private static void usage() {
        System.err.println("Usage: java edu.rit.mri.test.PlotData <datafile> [<rho1> <x1> ...]");
        System.err.println("<datafile> = File containing t and S(t) values");
        System.err.println("<rho1> = Spin density");
        System.err.println("<x1> = Spin relaxation rate");
        System.exit(1);
    }
}

