/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mri;

import edu.rit.io.Files;
import edu.rit.mp.ObjectBuf;
import edu.rit.mp.buf.ObjectItemBuf;
import edu.rit.mri.PixelAnalysis;
import edu.rit.mri.PixelChunk;
import edu.rit.mri.PixelSchedule;
import edu.rit.mri.PixelSignal;
import edu.rit.mri.PixelTissues;
import edu.rit.mri.SignalDataSetReader;
import edu.rit.mri.SpinSignal;
import edu.rit.mri.TissuesDataSetWriter;
import edu.rit.numeric.ArraySeries;
import edu.rit.numeric.Series;
import edu.rit.pj.Comm;
import edu.rit.pj.CommStatus;
import edu.rit.pj.ParallelRegion;
import edu.rit.pj.ParallelSection;
import edu.rit.pj.ParallelTeam;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public class SpinRelaxometryClu {
    static Comm world;
    static int size;
    static int rank;
    static double R1_lower;
    static double R1_upper;
    static int N;
    static String[] signalfilename;

    private SpinRelaxometryClu() {
    }

    public static void main(String[] stringArray) throws Exception {
        long l = System.currentTimeMillis();
        Comm.init(stringArray);
        world = Comm.world();
        size = world.size();
        rank = world.rank();
        if (stringArray.length < 4) {
            SpinRelaxometryClu.usage();
        }
        R1_lower = Double.parseDouble(stringArray[0]);
        R1_upper = Double.parseDouble(stringArray[1]);
        N = Integer.parseInt(stringArray[2]);
        signalfilename = new String[stringArray.length - 3];
        System.arraycopy(stringArray, 3, signalfilename, 0, stringArray.length - 3);
        if (rank == 0) {
            new ParallelTeam(2).execute(new ParallelRegion(){

                public void run() throws Exception {
                    this.execute(new ParallelSection(){

                        public void run() throws Exception {
                            SpinRelaxometryClu.masterSection();
                        }
                    }, new ParallelSection(){

                        public void run() throws Exception {
                            SpinRelaxometryClu.workerSection();
                        }
                    });
                }
            });
        } else {
            SpinRelaxometryClu.workerSection();
        }
        long l2 = System.currentTimeMillis();
        System.out.println(l2 - l + " msec " + rank);
    }

    private static void masterSection() throws IOException {
        PixelChunk pixelChunk;
        int n;
        TissuesDataSetWriter[] tissuesDataSetWriterArray = new TissuesDataSetWriter[signalfilename.length];
        for (int i = 0; i < tissuesDataSetWriterArray.length; ++i) {
            SignalDataSetReader signalDataSetReader = new SignalDataSetReader(new File(signalfilename[i]));
            int n2 = signalDataSetReader.getHeight();
            int n3 = signalDataSetReader.getWidth();
            signalDataSetReader.close();
            tissuesDataSetWriterArray[i] = new TissuesDataSetWriter(new File(Files.fileNamePrepend(signalfilename[i], "tissues_")), n2, n3);
        }
        PixelSchedule pixelSchedule = new PixelSchedule(100, signalfilename);
        int n4 = size;
        for (n = 0; n < size; ++n) {
            pixelChunk = pixelSchedule.next();
            world.send(n, ObjectBuf.buffer(pixelChunk));
            if (pixelChunk != null) continue;
            --n4;
        }
        while (n4 > 0) {
            ObjectItemBuf objectItemBuf = ObjectBuf.buffer();
            CommStatus commStatus = world.receive(null, objectItemBuf);
            n = commStatus.fromRank;
            pixelChunk = pixelSchedule.next();
            world.send(n, ObjectBuf.buffer(pixelChunk));
            if (pixelChunk == null) {
                --n4;
            }
            for (PixelTissues pixelTissues : (PixelTissues[])objectItemBuf.item) {
                if (pixelTissues == null) continue;
                tissuesDataSetWriterArray[pixelTissues.fileIndex()].addPixelTissues(pixelTissues);
            }
        }
        for (int i = 0; i < tissuesDataSetWriterArray.length; ++i) {
            tissuesDataSetWriterArray[i].close();
        }
    }

    private static void workerSection() throws IOException {
        int n = -1;
        SignalDataSetReader signalDataSetReader = null;
        Series series = null;
        int n2 = 0;
        double[][] dArray = null;
        double[] dArray2 = new double[N + 1];
        double d = Math.log(R1_lower);
        double d2 = Math.log(R1_upper);
        double d3 = (d2 - d) / (double)N;
        for (int i = 0; i <= N; ++i) {
            dArray2[i] = Math.exp(d + (double)i * d3);
        }
        ArraySeries arraySeries = new ArraySeries(dArray2);
        ArrayList<Double> arrayList = new ArrayList<Double>();
        ArrayList<Double> arrayList2 = new ArrayList<Double>();
        while (true) {
            ObjectItemBuf objectItemBuf = ObjectBuf.buffer();
            world.receive(0, objectItemBuf);
            PixelChunk pixelChunk = (PixelChunk)objectItemBuf.item;
            if (pixelChunk == null) break;
            int n3 = pixelChunk.fileIndex();
            int n4 = pixelChunk.pixelIndex();
            int n5 = pixelChunk.pixelCount();
            if (n3 != n) {
                if (signalDataSetReader != null) {
                    signalDataSetReader.close();
                }
                n = n3;
                signalDataSetReader = new SignalDataSetReader(new File(signalfilename[n3]));
                series = signalDataSetReader.getTimeSeries();
                n2 = series.length();
                dArray = new double[n2][N + 1];
                for (int i = 0; i < n2; ++i) {
                    double[] dArray3 = dArray[i];
                    double d4 = series.x(i);
                    for (int j = 0; j <= N; ++j) {
                        dArray3[j] = SpinSignal.S(dArray2[j], d4);
                    }
                }
            }
            PixelTissues[] pixelTissuesArray = new PixelTissues[n5];
            for (int i = 0; i < n5; ++i) {
                int n6 = n4 + i;
                PixelSignal pixelSignal = signalDataSetReader.getPixelSignal(n6);
                if (pixelSignal == null) continue;
                Series series2 = pixelSignal.S_measured();
                PixelAnalysis.analyze(series, series2, arraySeries, dArray, arrayList, arrayList2);
                pixelTissuesArray[i] = new PixelTissues(n3, n6, arrayList, arrayList2);
            }
            world.send(0, ObjectBuf.objectBuffer(pixelTissuesArray));
        }
        if (signalDataSetReader != null) {
            signalDataSetReader.close();
        }
    }

    private static void usage() {
        System.err.println("Usage: java -Dpj.np=<K> edu.rit.mri.SpinRelaxometryClu <R1_lower> <R1_upper> <N> <signalfile> [<signalfile> ...]");
        System.err.println("<K> = Number of parallel processes");
        System.err.println("<R1_lower> = Lower R1 spin-lattice relaxation rate (1/sec)");
        System.err.println("<R1_upper> = Upper R1 spin-lattice relaxation rate (1/sec)");
        System.err.println("<N> = Number of R1 intervals");
        System.err.println("<signalfile> = Input spin signal data set file");
        System.exit(1);
    }
}

