/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mri;

import edu.rit.mri.PixelSignal;
import edu.rit.numeric.Series;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class SignalDataSetWriter {
    private RandomAccessFile myFile;
    private int P;
    private int M;

    public SignalDataSetWriter(File file, int n, int n2, Series series) throws IOException {
        int n3;
        if (file == null) {
            throw new NullPointerException("SignalDataSetWriter(): theFile is null");
        }
        if (n < 0) {
            throw new IllegalArgumentException("SignalDataSetWriter(): Height (= " + n + ") < 0, illegal");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("SignalDataSetWriter(): Width (= " + n2 + ") < 0, illegal");
        }
        if (series == null) {
            throw new NullPointerException("SignalDataSetWriter(): t_series is null");
        }
        this.myFile = new RandomAccessFile(file, "rw");
        this.myFile.setLength(0L);
        this.myFile.writeInt(n);
        this.myFile.writeInt(n2);
        this.P = n * n2;
        for (n3 = 0; n3 < this.P; ++n3) {
            this.myFile.writeLong(0L);
        }
        this.M = series.length();
        this.myFile.writeShort((short)this.M);
        for (n3 = 0; n3 < this.M; ++n3) {
            this.myFile.writeDouble(series.x(n3));
        }
    }

    public void addPixelSignal(PixelSignal pixelSignal) throws IOException {
        if (pixelSignal == null) {
            throw new NullPointerException("SpinSignalDataSet.addPixelSignal(): signal is null");
        }
        int n = pixelSignal.pixelIndex();
        if (0 > n || n >= this.P) {
            throw new IndexOutOfBoundsException("SpinSignalDataSet.addPixelSignal(): Pixel index (= " + n + ") out of bounds");
        }
        if (pixelSignal.length() != this.M) {
            throw new IllegalArgumentException("SpinSignalDataSet.addPixelSignal(): Signal series length (= " + pixelSignal.length() + ") != time series length (= " + this.M + "), illegal");
        }
        long l = this.myFile.length();
        this.myFile.seek(8L + (long)n * 8L);
        this.myFile.writeLong(l);
        this.myFile.seek(l);
        pixelSignal.write(this.myFile);
    }

    public void close() throws IOException {
        this.myFile.close();
    }

    protected void finalize() {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

