/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mri;

import edu.rit.mri.PixelTissues;
import edu.rit.mri.TissuesDataSetReader;
import edu.rit.numeric.ListXYSeries;
import edu.rit.numeric.plot.Plot;
import edu.rit.numeric.plot.impl.LinearAxis;
import java.io.File;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;

public class R1Distribution {
    static final DecimalFormat FMT1 = new DecimalFormat("0.0");
    static final DecimalFormat FMT2 = new DecimalFormat("0.0E0");

    private R1Distribution() {
    }

    public static void main(String[] stringArray) throws Exception {
        int n;
        int n2;
        Object object;
        int n3;
        if (stringArray.length != 1 && stringArray.length != 3) {
            R1Distribution.usage();
        }
        File file = new File(stringArray[0]);
        double d = -1.0;
        double d2 = -1.0;
        if (stringArray.length == 3) {
            d = Double.parseDouble(stringArray[1]);
            d2 = Double.parseDouble(stringArray[2]);
        }
        TissuesDataSetReader tissuesDataSetReader = new TissuesDataSetReader(file);
        ArrayList<Double> arrayList = new ArrayList<Double>();
        int n4 = tissuesDataSetReader.getPixelCount();
        for (n3 = 0; n3 < n4; ++n3) {
            object = tissuesDataSetReader.getPixelTissues(n3);
            if (object == null) continue;
            n2 = ((PixelTissues)object).numTissues();
            for (n = 0; n < n2; ++n) {
                arrayList.add(((PixelTissues)object).R1(n));
            }
        }
        n3 = arrayList.size();
        object = new double[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            object[n2] = (Double)arrayList.get(n2);
        }
        Arrays.sort((double[])object);
        System.out.println("Decile\tR1");
        for (n2 = 0; n2 <= 9; ++n2) {
            System.out.print(FMT1.format((double)n2 / 10.0));
            System.out.print('\t');
            System.out.print((double)object[n3 * n2 / 10]);
            System.out.println();
        }
        System.out.print("1.0\t");
        System.out.print((double)object[n3 - 1]);
        System.out.println();
        ListXYSeries listXYSeries = new ListXYSeries();
        listXYSeries.add(0.0, 0.0);
        for (n = 0; n < n3; ++n) {
            listXYSeries.add((double)object[n], (double)n / (double)n3);
            listXYSeries.add((double)object[n], (double)(n + 1) / (double)n3);
        }
        if (d == -1.0) {
            d = 0.0;
            d2 = LinearAxis.autoscale((double)object[n3 - 1]);
        }
        Plot plot = new Plot();
        plot.plotTitle("<I>R</I>1 Distribution").xAxisLength(800.0).xAxisStart(d).xAxisEnd(d2).xAxisMajorDivisions(20).xAxisTickFormat(FMT2).xAxisTitle("Spin-Lattice Relaxation Rate, <I>R</I>1 (1/sec)").yAxisLength(400.0).yAxisStart(0.0).yAxisEnd(1.0).yAxisMajorDivisions(10).yAxisTickFormat(FMT1).yAxisTitle("Cumulative Distribution").seriesDots(null).xySeries(listXYSeries);
        plot.getFrame().setVisible(true);
    }

    private static void usage() {
        System.err.println("Usage: java edu.rit.mri.R1Distribution <tissuesfile> [<R1_lower> <R1_upper>]");
        System.err.println("<tissuesfile> = Tissues data set file");
        System.err.println("<R1_lower> = Lower R1 spin-lattice relaxation rate (1/sec)");
        System.err.println("<R1_upper> = Upper R1 spin-lattice relaxation rate (1/sec)");
        System.exit(1);
    }
}

