/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp.buf;

import edu.rit.mp.Buf;
import edu.rit.mp.Signed16BitIntegerBuf;
import edu.rit.mp.buf.Signed16BitIntegerMatrixBuf;
import edu.rit.pj.reduction.IntegerOp;
import edu.rit.pj.reduction.Op;
import edu.rit.pj.reduction.ReduceArrays;
import edu.rit.util.Range;
import java.nio.ByteBuffer;
import java.nio.ShortBuffer;

class Signed16BitIntegerMatrixReductionBuf
extends Signed16BitIntegerMatrixBuf {
    IntegerOp myOp;

    public Signed16BitIntegerMatrixReductionBuf(int[][] nArray, Range range, Range range2, IntegerOp integerOp) {
        super(nArray, range, range2);
        if (integerOp == null) {
            throw new NullPointerException("Signed16BitIntegerMatrixReductionBuf(): op is null");
        }
        this.myOp = integerOp;
    }

    public void put(int n, int n2) {
        int n3 = n / this.myColCount * this.myRowStride + this.myLowerRow;
        int n4 = n % this.myColCount * this.myColStride + this.myLowerCol;
        this.myMatrix[n3][n4] = this.myOp.op(this.myMatrix[n3][n4], n2);
    }

    public void copy(Buf buf) {
        if (buf != this) {
            if (buf instanceof Signed16BitIntegerMatrixBuf) {
                Signed16BitIntegerMatrixBuf signed16BitIntegerMatrixBuf = (Signed16BitIntegerMatrixBuf)buf;
                ReduceArrays.reduce(signed16BitIntegerMatrixBuf.myMatrix, signed16BitIntegerMatrixBuf.myRowRange, signed16BitIntegerMatrixBuf.myColRange, this.myMatrix, this.myRowRange, this.myColRange, this.myOp);
            } else {
                Signed16BitIntegerBuf.defaultCopy((Signed16BitIntegerBuf)buf, this);
            }
        }
    }

    public Buf getReductionBuf(Op op) {
        throw new UnsupportedOperationException();
    }

    protected int receiveItems(int n, int n2, ByteBuffer byteBuffer) {
        ShortBuffer shortBuffer = byteBuffer.asShortBuffer();
        n2 = Math.min(n2, shortBuffer.remaining());
        int n3 = 0;
        int n4 = this.i2r(n);
        int n5 = n4 * this.myRowStride + this.myLowerRow;
        int n6 = this.i2c(n);
        int n7 = n6 * this.myColStride + this.myLowerCol;
        int n8 = Math.min(this.myColCount - n6, n2);
        while (n4 < this.myRowCount && n8 > 0) {
            int[] nArray = this.myMatrix[n5];
            for (n6 = 0; n6 < n8; ++n6) {
                nArray[n7] = this.myOp.op(nArray[n7], shortBuffer.get());
                n7 += this.myColStride;
            }
            n3 += n8;
            ++n4;
            n5 += this.myRowStride;
            n7 = this.myLowerCol;
            n8 = Math.min(this.myColCount, n2 -= n8);
        }
        byteBuffer.position(byteBuffer.position() + 2 * n3);
        return n3;
    }
}

