/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp.buf;

import edu.rit.mp.Buf;
import edu.rit.mp.FloatBuf;
import edu.rit.mp.buf.FloatArrayReductionBuf;
import edu.rit.pj.reduction.FloatOp;
import edu.rit.pj.reduction.Op;
import edu.rit.util.Arrays;
import edu.rit.util.Range;
import java.nio.ByteBuffer;

public class FloatArrayBuf
extends FloatBuf {
    float[] myArray;
    Range myRange;
    int myArrayOffset;
    int myStride;

    public FloatArrayBuf(float[] fArray, Range range) {
        super(range.length());
        this.myArray = fArray;
        this.myRange = range;
        this.myArrayOffset = range.lb();
        this.myStride = range.stride();
    }

    public float get(int n) {
        return this.myArray[this.myArrayOffset + n * this.myStride];
    }

    public void put(int n, float f) {
        this.myArray[this.myArrayOffset + n * this.myStride] = f;
    }

    public void copy(Buf buf) {
        if (buf != this) {
            if (buf instanceof FloatArrayBuf) {
                FloatArrayBuf floatArrayBuf = (FloatArrayBuf)buf;
                Arrays.copy(floatArrayBuf.myArray, floatArrayBuf.myRange, this.myArray, this.myRange);
            } else {
                FloatBuf.defaultCopy((FloatBuf)buf, this);
            }
        }
    }

    public Buf getReductionBuf(Op op) {
        return new FloatArrayReductionBuf(this.myArray, this.myRange, (FloatOp)op);
    }

    protected int sendItems(int n, ByteBuffer byteBuffer) {
        int n2 = n;
        int n3 = this.myArrayOffset + n * this.myStride;
        while (n2 < this.myLength && byteBuffer.remaining() >= 4) {
            byteBuffer.putFloat(this.myArray[n3]);
            ++n2;
            n3 += this.myStride;
        }
        return n2 - n;
    }

    protected int receiveItems(int n, int n2, ByteBuffer byteBuffer) {
        int n3 = n;
        int n4 = this.myArrayOffset + n * this.myStride;
        int n5 = Math.min(n + n2, this.myLength);
        while (n3 < n5 && byteBuffer.remaining() >= 4) {
            this.myArray[n4] = byteBuffer.getFloat();
            ++n3;
            n4 += this.myStride;
        }
        return n3 - n;
    }
}

