/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.hyb.prime;

import edu.rit.hyb.prime.LongIterator;
import edu.rit.hyb.prime.Prime32List;
import edu.rit.hyb.prime.Sieve;
import edu.rit.mp.LongBuf;
import edu.rit.mp.buf.LongItemBuf;
import edu.rit.pj.Comm;
import edu.rit.pj.LongForLoop;
import edu.rit.pj.LongSchedule;
import edu.rit.pj.ParallelRegion;
import edu.rit.pj.ParallelTeam;
import edu.rit.pj.WorkerLongForLoop;
import edu.rit.pj.WorkerRegion;
import edu.rit.pj.WorkerTeam;
import edu.rit.pj.reduction.LongOp;
import edu.rit.pj.reduction.SharedLong;
import java.io.File;

public class PrimeCountFunctionHyb {
    static final int CHUNK = 1000000;
    static Comm world;
    static int rank;
    static long x;
    static File primeFile;
    static LongSchedule thrSchedule;
    static ParallelTeam team;
    static Sieve[] sieves;
    static Prime32List primeList;
    static SharedLong primeCount;

    private PrimeCountFunctionHyb() {
    }

    public static void main(String[] stringArray) throws Exception {
        long l = System.currentTimeMillis();
        Comm.init(stringArray);
        world = Comm.world();
        rank = world.rank();
        if (stringArray.length < 2 || stringArray.length > 3) {
            PrimeCountFunctionHyb.usage();
        }
        if ((x = Long.parseLong(stringArray[0])) < 0L) {
            PrimeCountFunctionHyb.usage();
        }
        primeFile = new File(stringArray[1]);
        thrSchedule = stringArray.length == 3 ? LongSchedule.parse(stringArray[2]) : LongSchedule.fixed();
        team = new ParallelTeam();
        sieves = new Sieve[team.getThreadCount()];
        for (int i = 0; i < sieves.length; ++i) {
            PrimeCountFunctionHyb.sieves[i] = new Sieve(0L, 1000000);
        }
        primeList = new Prime32List(primeFile);
        new WorkerTeam().execute(new WorkerRegion(){

            public void run() throws Exception {
                long l = (x + 1000000L - 1L) / 1000000L;
                this.execute(0L, l - 1L, new WorkerLongForLoop(){

                    public void run(final long l, final long l2) throws Exception {
                        team.execute(new ParallelRegion(){

                            public void run() throws Exception {
                                this.execute(l, l2, new LongForLoop(){
                                    Sieve thrSieve;
                                    long thrPrimeCount;
                                    long p0;
                                    long p1;
                                    long p2;
                                    long p3;
                                    long p4;
                                    long p5;
                                    long p6;
                                    long p7;
                                    long p8;
                                    long p9;
                                    long pa;
                                    long pb;
                                    long pc;
                                    long pd;
                                    long pe;
                                    long pf;

                                    public LongSchedule schedule() {
                                        return thrSchedule;
                                    }

                                    public void start() {
                                        this.thrSieve = sieves[this.getThreadIndex()];
                                        this.thrPrimeCount = 0L;
                                    }

                                    public void run(long l, long l2) throws Exception {
                                        for (long i = l; i <= l2; ++i) {
                                            long l3;
                                            LongIterator longIterator = primeList.iterator();
                                            this.thrSieve.lb(i * 1000000L);
                                            this.thrSieve.initialize();
                                            this.thrSieve.sieveOut(longIterator);
                                            longIterator = this.thrSieve.iterator();
                                            while ((l3 = longIterator.next()) != 0L && l3 <= x) {
                                                ++this.thrPrimeCount;
                                            }
                                        }
                                    }

                                    public void finish() {
                                        primeCount.addAndGet(this.thrPrimeCount);
                                    }
                                });
                            }
                        });
                    }
                });
            }
        });
        LongItemBuf longItemBuf = LongBuf.buffer(primeCount.longValue());
        world.reduce(0, longItemBuf, LongOp.SUM);
        long l2 = System.currentTimeMillis();
        if (rank == 0) {
            System.out.println("pi(" + x + ") = " + (longItemBuf.item + 1L));
        }
        System.out.println(l2 - l + " msec " + rank);
    }

    private static void usage() {
        System.err.println("Usage: java -Dpj.np=<Kp> -Dpj.nt=<Kt> [ -Dpj.schedule=<procschedule> ] edu.rit.hyb.prime.PrimeCountFunctionHyb <x> <primefile> [ <thrschedule> ]");
        System.err.println("<Kp> = Number of parallel processes");
        System.err.println("<Kt> = Number of parallel threads per process");
        System.err.println("<procschedule> = Load balancing schedule for processes");
        System.err.println("<x> = Argument of prime counting function, 0 <= <x> <= 2^63-1");
        System.err.println("<primefile> = Prime file name");
        System.err.println("<thrschedule> = Load balancing schedule for threads System.exit (1);");
    }

    static {
        primeCount = new SharedLong(0L);
    }
}

