/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.hyb.fractal;

import edu.rit.color.HSB;
import edu.rit.image.PJGColorImage;
import edu.rit.image.PJGImage;
import edu.rit.io.Files;
import edu.rit.pj.Comm;
import edu.rit.pj.IntegerForLoop;
import edu.rit.pj.IntegerSchedule;
import edu.rit.pj.ParallelRegion;
import edu.rit.pj.ParallelTeam;
import edu.rit.pj.WorkerIntegerForLoop;
import edu.rit.pj.WorkerRegion;
import edu.rit.pj.WorkerTeam;
import edu.rit.util.Range;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;

public class MandelbrotSetHyb2 {
    static Comm world;
    static int rank;
    static int width;
    static int height;
    static double xcenter;
    static double ycenter;
    static double resolution;
    static int maxiter;
    static double gamma;
    static File filename;
    static IntegerSchedule thrschedule;
    static int xoffset;
    static int yoffset;
    static int[][] matrix;
    static PJGColorImage image;
    static PJGImage.Writer writer;
    static int[][] slice;
    static int[] huetable;
    static ParallelTeam team;

    private MandelbrotSetHyb2() {
    }

    public static void main(String[] stringArray) throws Exception {
        long l = System.currentTimeMillis();
        Comm.init(stringArray);
        world = Comm.world();
        rank = world.rank();
        if (stringArray.length < 8 || stringArray.length > 9) {
            MandelbrotSetHyb2.usage();
        }
        width = Integer.parseInt(stringArray[0]);
        height = Integer.parseInt(stringArray[1]);
        xcenter = Double.parseDouble(stringArray[2]);
        ycenter = Double.parseDouble(stringArray[3]);
        resolution = Double.parseDouble(stringArray[4]);
        maxiter = Integer.parseInt(stringArray[5]);
        gamma = Double.parseDouble(stringArray[6]);
        filename = new File(stringArray[7]);
        thrschedule = stringArray.length == 9 ? IntegerSchedule.parse(stringArray[8]) : IntegerSchedule.fixed();
        xoffset = -(width - 1) / 2;
        yoffset = (height - 1) / 2;
        matrix = new int[height][];
        image = new PJGColorImage(height, width, matrix);
        writer = image.prepareToWrite(new BufferedOutputStream(new FileOutputStream(Files.fileForRank(filename, rank))));
        huetable = new int[maxiter + 1];
        for (int i = 0; i < maxiter; ++i) {
            MandelbrotSetHyb2.huetable[i] = HSB.pack((float)Math.pow((double)i / (double)maxiter, gamma), 1.0f, 1.0f);
        }
        MandelbrotSetHyb2.huetable[MandelbrotSetHyb2.maxiter] = HSB.pack(1.0f, 1.0f, 0.0f);
        team = new ParallelTeam();
        long l2 = System.currentTimeMillis();
        new WorkerTeam().execute(new WorkerRegion(){

            public void run() throws Exception {
                this.execute(0, height - 1, new WorkerIntegerForLoop(){

                    public void run(final int n, final int n2) throws Exception {
                        Range range = new Range(n, n2);
                        int n3 = range.length();
                        if (slice == null || slice.length < n3) {
                            slice = new int[n3][width];
                        }
                        team.execute(new ParallelRegion(){

                            public void run() throws Exception {
                                this.execute(n, n2, new IntegerForLoop(){

                                    public IntegerSchedule schedule() {
                                        return thrschedule;
                                    }

                                    public void run(int n, int n2) {
                                        for (int i = n; i <= n2; ++i) {
                                            int[] nArray = slice[i - n];
                                            double d = ycenter + (double)(yoffset - i) / resolution;
                                            for (int j = 0; j < width; ++j) {
                                                int n3;
                                                double d2 = xcenter + (double)(xoffset + j) / resolution;
                                                double d3 = 0.0;
                                                double d4 = 0.0;
                                                double d5 = 0.0;
                                                double d6 = 0.0;
                                                double d7 = 0.0;
                                                for (n3 = 0; n3 < maxiter && d7 <= 4.0; ++n3) {
                                                    d5 = d3 * d3 - d4 * d4 + d2;
                                                    d6 = 2.0 * d3 * d4 + d;
                                                    d7 = d5 * d5 + d6 * d6;
                                                    d3 = d5;
                                                    d4 = d6;
                                                }
                                                nArray[j] = huetable[n3];
                                            }
                                        }
                                    }
                                });
                            }
                        });
                        System.arraycopy(slice, 0, matrix, n, n3);
                        writer.writeRowSlice(range);
                    }
                });
            }
        });
        long l3 = System.currentTimeMillis();
        writer.close();
        long l4 = System.currentTimeMillis();
        System.out.println(l2 - l + " msec pre " + rank);
        System.out.println(l3 - l2 + " msec calc " + rank);
        System.out.println(l4 - l3 + " msec post " + rank);
        System.out.println(l4 - l + " msec total " + rank);
    }

    private static void usage() {
        System.err.println("Usage: java -Dpj.np=<Kp> -Dpj.nt=<Kt> [-Dpj.schedule=<procschedule>] edu.rit.hyb.fractal.MandelbrotSetHyb2 <width> <height> <xcenter> <ycenter> <resolution> <maxiter> <gamma> <filename> [<thrschedule>]");
        System.err.println("<Kp> = Number of parallel processes");
        System.err.println("<Kt> = Number of parallel threads per process");
        System.err.println("<procschedule> = Load balancing schedule for processes");
        System.err.println("<width> = Image width (pixels)");
        System.err.println("<height> = Image height (pixels)");
        System.err.println("<xcenter> = X coordinate of center point");
        System.err.println("<ycenter> = Y coordinate of center point");
        System.err.println("<resolution> = Pixels per unit");
        System.err.println("<maxiter> = Maximum number of iterations");
        System.err.println("<gamma> = Used to calculate pixel hues");
        System.err.println("<filename> = PJG image file name");
        System.err.println("<thrschedule> = Load balancing schedule for threads");
        System.exit(1);
    }
}

