/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.compbio.phyl;

import edu.rit.compbio.phyl.DnaSequence;
import edu.rit.compbio.phyl.DnaSequenceTree;
import edu.rit.draw.Drawing;
import edu.rit.draw.item.Group;
import edu.rit.draw.item.Line;
import edu.rit.draw.item.Point;
import edu.rit.draw.item.Text;
import java.io.PrintStream;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TreeDrawing {
    private static final double V = 27.0;
    private static final double H = 72.0;
    private static final double GAP = 6.0;
    private static final double VGAP = 3.0;
    private static final Pattern pattern = Pattern.compile("\\(|\\)|,|:|;|[^(),:; \\t\\n\\x0B\\f\\r]+");
    private String treestring;
    private DecimalFormat format = new DecimalFormat("0.00");
    private Matcher matcher;
    private String token;
    private int index;
    private int tipCount;
    private Group group;

    public void setBranchLengthFormat(String string) {
        this.format = new DecimalFormat(string);
    }

    public void draw(DnaSequenceTree dnaSequenceTree) {
        this.draw(dnaSequenceTree, Drawing.defaultDrawing());
    }

    public void draw(DnaSequenceTree dnaSequenceTree, Drawing drawing) {
        this.draw(dnaSequenceTree, new Group());
        drawing.add(this.group);
    }

    public void draw(DnaSequenceTree dnaSequenceTree, Group group) {
        this.tipCount = 0;
        this.group = group;
        Point point = this.drawNode(dnaSequenceTree, dnaSequenceTree.root());
        group.append(new Line().to(point).hby(-72.0));
    }

    public void draw(String string) throws SyntaxException {
        this.draw(string, Drawing.defaultDrawing());
    }

    public void draw(String string, Drawing drawing) throws SyntaxException {
        this.draw(string, new Group());
        drawing.add(this.group);
    }

    public void draw(String string, Group group) throws SyntaxException {
        this.treestring = string;
        this.tipCount = 0;
        this.group = group;
        this.matcher = pattern.matcher(this.treestring);
        this.nextToken();
        Point point = this.parseNode();
        if (!";".equals(this.token)) {
            this.syntaxError("; expected");
        }
        this.nextToken();
        if (this.token != null) {
            this.syntaxError("Extra characters");
        }
        group.append(new Line().to(point).hby(-72.0));
    }

    private Point drawNode(DnaSequenceTree dnaSequenceTree, int n) {
        Serializable serializable;
        Object object;
        Point point;
        boolean bl;
        boolean bl2 = bl = dnaSequenceTree.child1(n) == -1;
        if (bl) {
            point = new Point(0.0, (double)this.tipCount * 27.0);
            ++this.tipCount;
        } else {
            object = this.drawNode(dnaSequenceTree, dnaSequenceTree.child1(n));
            serializable = this.drawNode(dnaSequenceTree, dnaSequenceTree.child2(n));
            double d = Math.min(((Point)object).x(), ((Point)serializable).x()) - 72.0;
            double d2 = ((Point)object).y();
            double d3 = ((Point)serializable).y();
            point = new Point(d, (d2 + d3) / 2.0);
            this.group.append(new Line().to((Point)object).hto(d).vto((Point)serializable).hto((Point)serializable));
        }
        object = dnaSequenceTree.seq(n);
        if (object != null) {
            this.drawName(((DnaSequence)object).name(), point);
        }
        if ((serializable = dnaSequenceTree.branchLength(n)) != null) {
            this.drawBranchLength((Double)serializable, point, bl);
        }
        return point;
    }

    private void drawName(String string, Point point) {
        if (string != null) {
            this.group.append(new Text().text(string).w(point.e(6.0)));
        }
    }

    private void drawBranchLength(double d, Point point, boolean bl) {
        if (bl) {
            this.group.append(new Text().text(this.format.format(d)).se(point.n(3.0).w(6.0)));
        } else {
            this.group.append(new Text().text(this.format.format(d)).s(point.n(3.0).w(36.0)));
        }
    }

    private Point parseNode() throws SyntaxException {
        if (!"(".equals(this.token)) {
            this.syntaxError("( expected");
        }
        this.nextToken();
        Point point = this.parseChildList();
        if (!")".equals(this.token)) {
            this.syntaxError(") expected");
        }
        this.nextToken();
        this.parseNameLength(point, false);
        return point;
    }

    private void parseNameLength(Point point, boolean bl) throws SyntaxException {
        if (this.isName(this.token)) {
            this.drawName(this.token.replaceAll("_", " "), point);
            this.nextToken();
        }
        if (":".equals(this.token)) {
            this.nextToken();
            double d = 0.0;
            try {
                d = new Double(this.token);
            }
            catch (NullPointerException nullPointerException) {
                this.syntaxError("Branch length expected");
            }
            catch (NumberFormatException numberFormatException) {
                this.syntaxError("Branch length expected");
            }
            this.nextToken();
            this.drawBranchLength(d, point, bl);
        }
    }

    private boolean isName(String string) {
        return string != null && !"(".equals(string) && !")".equals(string) && !",".equals(string) && !":".equals(string) && !";".equals(string);
    }

    private Point parseChildList() throws SyntaxException {
        LinkedList<Point> linkedList = new LinkedList<Point>();
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        while (true) {
            Point point = this.parseChild();
            linkedList.add(point);
            d = Math.min(d, point.x());
            if (!",".equals(this.token)) break;
            this.nextToken();
        }
        d -= 72.0;
        for (Point point : linkedList) {
            this.group.append(new Line().to(point).hto(d));
        }
        d2 = ((Point)linkedList.get(0)).y();
        d3 = ((Point)linkedList.get(linkedList.size() - 1)).y();
        this.group.append(new Line().to(d, d2).to(d, d3));
        return new Point(d, (d2 + d3) / 2.0);
    }

    private Point parseChild() throws SyntaxException {
        if ("(".equals(this.token)) {
            return this.parseNode();
        }
        return this.parseTip();
    }

    private Point parseTip() throws SyntaxException {
        Point point = new Point(0.0, (double)this.tipCount * 27.0);
        ++this.tipCount;
        this.parseNameLength(point, true);
        return point;
    }

    private void nextToken() {
        if (this.matcher.find()) {
            this.token = this.treestring.substring(this.matcher.start(), this.matcher.end());
            this.index = this.matcher.start();
        } else {
            this.token = null;
            this.index = this.treestring.length();
        }
    }

    private void syntaxError(String string) throws SyntaxException {
        throw new SyntaxException(this.treestring, this.index, string);
    }

    public static class SyntaxException
    extends Exception {
        private String treestring;
        private int index;

        private SyntaxException(String string, int n, String string2) {
            super(string2);
            this.treestring = string;
            this.index = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void printSyntaxError(PrintStream printStream) {
            PrintStream printStream2 = printStream;
            synchronized (printStream2) {
                printStream.println("Syntax error: " + this.getMessage());
                printStream.println(this.treestring);
                for (int i = 0; i < this.index; ++i) {
                    printStream.print(' ');
                }
                printStream.println('^');
            }
        }
    }
}

