/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.compbio.phyl;

import edu.rit.compbio.phyl.Distance;
import edu.rit.compbio.phyl.DnaSequence;
import edu.rit.compbio.phyl.DnaSequenceTree;
import edu.rit.numeric.NonNegativeLeastSquares;

public class LeastSquaresBranchLengths {
    private LeastSquaresBranchLengths() {
    }

    public static double squaredError(DnaSequenceTree dnaSequenceTree, Distance distance) {
        double[] dArray = LeastSquaresBranchLengths.getBranchLengths(dnaSequenceTree);
        int[] nArray = LeastSquaresBranchLengths.getTipNodes(dnaSequenceTree);
        boolean[][] blArray = LeastSquaresBranchLengths.getRootPaths(dnaSequenceTree, nArray);
        int n = nArray.length;
        double d = 0.0;
        for (int i = 0; i < n - 1; ++i) {
            DnaSequence dnaSequence = dnaSequenceTree.seq(nArray[i]);
            for (int j = i + 1; j < n; ++j) {
                DnaSequence dnaSequence2 = dnaSequenceTree.seq(nArray[j]);
                double d2 = distance.distance(dnaSequence, dnaSequence2);
                double d3 = LeastSquaresBranchLengths.treeDistance(i, j, dArray, blArray);
                double d4 = d2 - d3;
                d += d4 * d4;
            }
        }
        return d;
    }

    public static double solve(DnaSequenceTree dnaSequenceTree, Distance distance) {
        int n;
        double[] dArray = LeastSquaresBranchLengths.getBranchLengths(dnaSequenceTree);
        int[] nArray = LeastSquaresBranchLengths.getTipNodes(dnaSequenceTree);
        boolean[][] blArray = LeastSquaresBranchLengths.getRootPaths(dnaSequenceTree, nArray);
        int n2 = dArray.length;
        int n3 = nArray.length;
        int n4 = n3 * (n3 - 1) / 2;
        NonNegativeLeastSquares nonNegativeLeastSquares = new NonNegativeLeastSquares(n4, n2);
        int n5 = 0;
        for (n = 0; n < n3 - 1; ++n) {
            DnaSequence dnaSequence = dnaSequenceTree.seq(nArray[n]);
            boolean[] blArray2 = blArray[n];
            for (int i = n + 1; i < n3; ++i) {
                DnaSequence dnaSequence2 = dnaSequenceTree.seq(nArray[i]);
                boolean[] blArray3 = blArray[i];
                nonNegativeLeastSquares.b[n5] = distance.distance(dnaSequence, dnaSequence2);
                double[] dArray2 = nonNegativeLeastSquares.a[n5];
                for (int j = 0; j < n2; ++j) {
                    dArray2[j] = blArray2[j] ^ blArray3[j] ? 1.0 : 0.0;
                }
                ++n5;
            }
        }
        nonNegativeLeastSquares.solve();
        for (n = 0; n < n2; ++n) {
            dnaSequenceTree.branchLength(n, nonNegativeLeastSquares.x[n]);
        }
        dnaSequenceTree.branchLength(dnaSequenceTree.root(), null);
        return nonNegativeLeastSquares.normsqr;
    }

    private static double[] getBranchLengths(DnaSequenceTree dnaSequenceTree) {
        int n = dnaSequenceTree.length();
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            Double d = dnaSequenceTree.branchLength(i);
            if (d == null) continue;
            dArray[i] = d;
        }
        return dArray;
    }

    private static int[] getTipNodes(DnaSequenceTree dnaSequenceTree) {
        int n = dnaSequenceTree.length();
        int n2 = (n + 1) / 2;
        int[] nArray = new int[n2];
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            if (dnaSequenceTree.child1(i) != -1) continue;
            nArray[n3++] = i;
        }
        return nArray;
    }

    private static boolean[][] getRootPaths(DnaSequenceTree dnaSequenceTree, int[] nArray) {
        int n = dnaSequenceTree.length();
        int n2 = nArray.length;
        boolean[][] blArray = new boolean[n2][n];
        for (int i = 0; i < n2; ++i) {
            boolean[] blArray2 = blArray[i];
            int n3 = nArray[i];
            while (n3 != -1) {
                blArray2[n3] = true;
                n3 = dnaSequenceTree.parent(n3);
            }
        }
        return blArray;
    }

    private static double treeDistance(int n, int n2, double[] dArray, boolean[][] blArray) {
        boolean[] blArray2 = blArray[n];
        boolean[] blArray3 = blArray[n2];
        int n3 = blArray[0].length;
        double d = 0.0;
        for (int i = 0; i < n3; ++i) {
            if (!(blArray2[i] ^ blArray3[i])) continue;
            d += dArray[i];
        }
        return d;
    }
}

