/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.clu.antimatter;

import edu.rit.vector.Vector2D;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import javax.swing.JPanel;

public class TrapPanel
extends JPanel {
    private static final int W = 500;
    private static final double DIAM = 5.0;
    private static final double RADIUS = 2.5;
    private static final Color PARTICLE_COLOR = Color.red;
    private Vector2D[] pArray;
    private double scale;
    private Ellipse2D dot = new Ellipse2D.Double();
    private boolean iamWaitingForRepaint = false;

    public TrapPanel(Vector2D[] vector2DArray, double d) {
        Dimension dimension = new Dimension(500, 500);
        this.setMinimumSize(dimension);
        this.setPreferredSize(dimension);
        this.setMaximumSize(dimension);
        this.pArray = vector2DArray;
        this.scale = 500.0 / d;
    }

    public synchronized void step() {
        this.iamWaitingForRepaint = true;
        this.repaint(0L, 0, 0, 500, 500);
        while (this.iamWaitingForRepaint) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    protected synchronized void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(PARTICLE_COLOR);
        for (Vector2D vector2D : this.pArray) {
            this.dot.setFrame(vector2D.x * this.scale - 2.5, vector2D.y * this.scale - 2.5, 5.0, 5.0);
            graphics2D.fill(this.dot);
        }
        this.iamWaitingForRepaint = false;
        this.notifyAll();
    }
}

