/*
 * Decompiled with CFR 0.152.
 */
import edu.rit.numeric.AggregateXYSeries;
import edu.rit.numeric.ListSeries;
import edu.rit.numeric.NonNegativeLeastSquares;
import edu.rit.numeric.plot.Dots;
import edu.rit.numeric.plot.Plot;
import java.awt.Color;
import java.io.File;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Map;
import java.util.Scanner;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TimeFit {
    private static Pattern N_POWER_PATTERN = Pattern.compile("n\\^([0-9]+)");
    private static Pattern N_POWER_TIMES_K_PATTERN = Pattern.compile("n\\^([0-9]+)K");
    private static Pattern N_POWER_OVER_K_PATTERN = Pattern.compile("n\\^([0-9]+)/K");
    private static Pattern QUOTED_STRING_PATTERN = Pattern.compile("\"[^\"]*\"");
    private static DecimalFormat FMT_0 = new DecimalFormat("0");
    private static DecimalFormat FMT_0E = new DecimalFormat("0E0");
    private static DecimalFormat FMT_1 = new DecimalFormat("0.0");
    private static DecimalFormat FMT_2 = new DecimalFormat("0.00");
    private static DecimalFormat FMT_3 = new DecimalFormat("0.000");
    private static Map<Integer, Data> dataMap = new TreeMap<Integer, Data>();
    private static double K_max = Double.NEGATIVE_INFINITY;
    private static Plot T_plot = new Plot();
    private static Plot Speedup_plot = new Plot();
    private static Plot Eff_plot = new Plot();
    private static Plot EDSF_plot = new Plot();
    private static File inputfile;
    private static int nplot;
    private static ArrayList<BasisFunction> basis;
    private static final double LOG_2;

    private TimeFit() {
    }

    public static void main(String[] stringArray) throws Exception {
        int n;
        double d;
        double d2;
        Object object;
        if (stringArray.length < 3) {
            TimeFit.usage();
        }
        inputfile = new File(stringArray[0]);
        nplot = Integer.parseInt(stringArray[1]);
        for (int i = 2; i < stringArray.length; ++i) {
            basis.add(TimeFit.parseBasisFunction(stringArray[i]));
        }
        T_plot.plotTitle("n = " + nplot).rightMargin(72.0).minorGridLines(true).xAxisKind(Plot.LOGARITHMIC).xAxisMinorDivisions(10).xAxisTitle("Processors, K").yAxisKind(Plot.LOGARITHMIC).yAxisMinorDivisions(10).yAxisTickFormat(FMT_0E).yAxisTickScale(1000.0).yAxisTitle("Running Time, T (sec)").labelPosition(5).labelOffset(6.0);
        Speedup_plot.plotTitle("n = " + nplot).rightMargin(72.0).xAxisStart(0.0).xAxisTitle("Processors, K").yAxisStart(0.0).yAxisTitle("Speedup").labelPosition(5).labelOffset(6.0);
        Eff_plot.plotTitle("n = " + nplot).rightMargin(72.0).xAxisStart(0.0).xAxisTitle("Processors, K").yAxisStart(0.0).yAxisTickFormat(FMT_1).yAxisTitle("Efficiency").labelPosition(5).labelOffset(6.0);
        EDSF_plot.plotTitle("n = " + nplot).rightMargin(72.0).xAxisStart(0.0).xAxisTitle("Processors, K").yAxisStart(0.0).yAxisTickFormat(FMT_0).yAxisTickScale(0.001).yAxisTitle("Sequential Fraction, F (/1000)").labelPosition(5).labelOffset(6.0);
        Scanner scanner = new Scanner(inputfile);
        int n2 = 1;
        while (scanner.hasNextLine()) {
            object = scanner.nextLine();
            int n3 = ((String)object).indexOf(35);
            if (n3 >= 0) {
                object = ((String)object).substring(0, n3);
            }
            if (((String)(object = ((String)object).trim())).length() > 0) {
                TimeFit.parseLine((String)object, n2);
            }
            ++n2;
        }
        for (Data data : dataMap.values()) {
            TimeFit.validateData(data);
        }
        object = new ListSeries();
        ListSeries listSeries = new ListSeries();
        ListSeries listSeries2 = new ListSeries();
        for (Data data : dataMap.values()) {
            double d3 = data.n;
            for (int i = 0; i < data.K_series.length(); ++i) {
                double d4 = data.K_series.x(i);
                double d5 = data.T_series.x(i);
                if (!(d4 >= 1.0)) continue;
                ((ListSeries)object).add(d3);
                listSeries.add(d4);
                listSeries2.add(d5);
            }
        }
        int n4 = ((ListSeries)object).length();
        int n5 = basis.size();
        NonNegativeLeastSquares nonNegativeLeastSquares = new NonNegativeLeastSquares(n4, n5);
        for (int i = 0; i < n4; ++i) {
            double d6 = ((ListSeries)object).x(i);
            d2 = listSeries.x(i);
            d = listSeries2.x(i);
            for (int j = 0; j < n5; ++j) {
                nonNegativeLeastSquares.a[i][j] = basis.get(j).f(d6, d2);
            }
            nonNegativeLeastSquares.b[i] = d;
        }
        nonNegativeLeastSquares.solve();
        Data data = dataMap.get(nplot);
        if (data == null) {
            System.err.println("No data for n = " + nplot);
            System.exit(1);
        }
        Data data2 = new Data(nplot);
        for (n = 0; n < data.K_series.length(); ++n) {
            d2 = data.K_series.x(n);
            d = TimeFit.modelFunction(nplot, d2, nonNegativeLeastSquares.x);
            if (d2 == 1.0) {
                data2.T_par_1 = d;
            }
            double d7 = data2.T_par_1 / d;
            double d8 = d7 / d2;
            data2.K_series.add(d2);
            data2.T_series.add(d);
            data2.Speedup_series.add(d7);
            data2.Eff_series.add(d8);
            if (!(d2 >= 2.0)) continue;
            double d9 = (d2 * d - data2.T_par_1) / data2.T_par_1 / (d2 - 1.0);
            data2.K_series_2.add(d2);
            data2.EDSF_series_2.add(d9);
        }
        System.out.println("Actual");
        TimeFit.printData(data);
        System.out.println("Model");
        TimeFit.printData(data2);
        System.out.print("T(n,K)");
        for (n = 0; n < n5; ++n) {
            System.out.print(n == 0 ? " = " : " + ");
            System.out.print(basis.get(n).toString(nonNegativeLeastSquares.x[n]));
        }
        System.out.println();
        System.out.println("chi^2 = " + nonNegativeLeastSquares.normsqr);
        Speedup_plot.seriesDots(null).seriesColor(new Color(0.7f, 0.7f, 0.7f)).xySeries(new double[]{0.0, K_max}, new double[]{0.0, K_max});
        Eff_plot.seriesDots(null).seriesColor(new Color(0.7f, 0.7f, 0.7f)).xySeries(new double[]{0.0, K_max}, new double[]{1.0, 1.0});
        T_plot.seriesDots(null).seriesColor(Color.RED).labelColor(Color.RED);
        Speedup_plot.seriesDots(null).seriesColor(Color.RED).labelColor(Color.RED);
        Eff_plot.seriesDots(null).seriesColor(Color.RED).labelColor(Color.RED);
        EDSF_plot.seriesDots(null).seriesColor(Color.RED).labelColor(Color.RED);
        TimeFit.plotData(data2, "Model");
        T_plot.seriesDots(Dots.circle(5.0)).seriesColor(Color.BLACK).labelColor(Color.BLACK);
        Speedup_plot.seriesDots(Dots.circle(5.0)).seriesColor(Color.BLACK).labelColor(Color.BLACK);
        Eff_plot.seriesDots(Dots.circle(5.0)).seriesColor(Color.BLACK).labelColor(Color.BLACK);
        EDSF_plot.seriesDots(Dots.circle(5.0)).seriesColor(Color.BLACK).labelColor(Color.BLACK);
        TimeFit.plotData(data, "Actual");
        T_plot.getFrame().setVisible(true);
        Speedup_plot.getFrame().setVisible(true);
        Eff_plot.getFrame().setVisible(true);
        EDSF_plot.getFrame().setVisible(true);
    }

    private static BasisFunction parseBasisFunction(String string) {
        if (string.equals("1")) {
            return new BasisFunction(){

                public double f(double d, double d2) {
                    return 1.0;
                }

                public String toString(double d) {
                    return d + "";
                }
            };
        }
        if (string.equals("K")) {
            return new BasisFunction(){

                public double f(double d, double d2) {
                    return d2;
                }

                public String toString(double d) {
                    return d + " K";
                }
            };
        }
        if (string.equals("1/K")) {
            return new BasisFunction(){

                public double f(double d, double d2) {
                    return 1.0 / d2;
                }

                public String toString(double d) {
                    return d + " / K";
                }
            };
        }
        if (string.equals("n")) {
            return new BasisFunction(){

                public double f(double d, double d2) {
                    return d;
                }

                public String toString(double d) {
                    return d + " n";
                }
            };
        }
        if (string.equals("nK")) {
            return new BasisFunction(){

                public double f(double d, double d2) {
                    return d * d2;
                }

                public String toString(double d) {
                    return d + " n K";
                }
            };
        }
        if (string.equals("n/K")) {
            return new BasisFunction(){

                public double f(double d, double d2) {
                    return d / d2;
                }

                public String toString(double d) {
                    return d + " n / K";
                }
            };
        }
        Matcher matcher = N_POWER_PATTERN.matcher(string);
        if (matcher.matches()) {
            final int n = Integer.parseInt(matcher.group(1));
            return new BasisFunction(){

                public double f(double d, double d2) {
                    return Math.pow(d, n);
                }

                public String toString(double d) {
                    return d + " n^" + n;
                }
            };
        }
        matcher = N_POWER_TIMES_K_PATTERN.matcher(string);
        if (matcher.matches()) {
            final int n = Integer.parseInt(matcher.group(1));
            return new BasisFunction(){

                public double f(double d, double d2) {
                    return Math.pow(d, n) * d2;
                }

                public String toString(double d) {
                    return d + " n^" + n + " K";
                }
            };
        }
        matcher = N_POWER_OVER_K_PATTERN.matcher(string);
        if (matcher.matches()) {
            final int n = Integer.parseInt(matcher.group(1));
            return new BasisFunction(){

                public double f(double d, double d2) {
                    return Math.pow(d, n) / d2;
                }

                public String toString(double d) {
                    return d + " n^" + n + " / K";
                }
            };
        }
        if (string.equals("lgn")) {
            return new BasisFunction(){

                public double f(double d, double d2) {
                    return Math.log(d) / LOG_2;
                }

                public String toString(double d) {
                    return d + " lg n";
                }
            };
        }
        if (string.equals("lgnK")) {
            return new BasisFunction(){

                public double f(double d, double d2) {
                    return Math.log(d) / LOG_2 * d2;
                }

                public String toString(double d) {
                    return d + " (lg n) K";
                }
            };
        }
        if (string.equals("lgn/K")) {
            return new BasisFunction(){

                public double f(double d, double d2) {
                    return Math.log(d) / LOG_2 / d2;
                }

                public String toString(double d) {
                    return d + " (lg n) / K";
                }
            };
        }
        if (string.equals("2^n")) {
            return new BasisFunction(){

                public double f(double d, double d2) {
                    return Math.pow(2.0, d);
                }

                public String toString(double d) {
                    return d + " (2^n)";
                }
            };
        }
        if (string.equals("2^nK")) {
            return new BasisFunction(){

                public double f(double d, double d2) {
                    return Math.pow(2.0, d) * d2;
                }

                public String toString(double d) {
                    return d + " (2^n) K";
                }
            };
        }
        if (string.equals("2^n/K")) {
            return new BasisFunction(){

                public double f(double d, double d2) {
                    return Math.pow(2.0, d) / d2;
                }

                public String toString(double d) {
                    return d + " (2^n) / K";
                }
            };
        }
        System.err.println("Illegal basis function: " + string);
        System.exit(1);
        return null;
    }

    private static void parseLine(String string, int n) {
        Scanner scanner = new Scanner(string);
        if (scanner.hasNextInt()) {
            int n2;
            int n3 = scanner.nextInt();
            if (!scanner.hasNextInt()) {
                TimeFit.error("K invalid", n);
            }
            if ((n2 = scanner.nextInt()) < 0) {
                TimeFit.error("K < 0", n);
            }
            if (n2 == 0) {
                return;
            }
            K_max = Math.max(K_max, (double)n2);
            double d = Double.POSITIVE_INFINITY;
            double d2 = Double.NEGATIVE_INFINITY;
            while (scanner.hasNextLong()) {
                double d3 = scanner.nextLong();
                if (d3 <= 0.0) {
                    TimeFit.error("T invalid", n);
                }
                d = Math.min(d, d3);
                d2 = Math.max(d2, d3);
            }
            if (d == Double.POSITIVE_INFINITY) {
                TimeFit.error("T values missing", n);
            }
            Data data = TimeFit.getData(n3);
            if (n2 == 0) {
                data.T_seq = d;
                data.T_max_seq = d2;
                data.Dev_seq = (d2 - d) / d;
            } else if (n2 == 1) {
                double d4;
                double d5 = d4 = data.T_seq == 0.0 ? 1.0 : data.T_seq / d;
                double d6 = (d2 - d) / d;
                data.T_par_1 = d;
                data.K_series.add(n2);
                data.T_series.add(d);
                data.T_max_series.add(d2);
                data.Speedup_series.add(d4);
                data.Eff_series.add(d5);
                data.Dev_series.add(d6);
            } else {
                double d7 = data.T_seq == 0.0 ? data.T_par_1 / d : data.T_seq / d;
                double d8 = d7 / (double)n2;
                double d9 = (d2 - d) / d;
                double d10 = ((double)n2 * d - data.T_par_1) / data.T_par_1 / (double)(n2 - 1);
                data.K_series.add(n2);
                data.T_series.add(d);
                data.T_max_series.add(d2);
                data.Speedup_series.add(d7);
                data.Eff_series.add(d8);
                data.Dev_series.add(d9);
                data.K_series_2.add(n2);
                data.EDSF_series_2.add(d10);
            }
        } else {
            String string2 = scanner.next();
            if (string2.equals("n")) {
                if (!scanner.hasNextInt()) {
                    TimeFit.error("Missing n value", n);
                }
                int n4 = scanner.nextInt();
                if (!scanner.hasNextDouble()) {
                    TimeFit.error("Missing N value", n);
                }
                double d = scanner.nextDouble();
                String string3 = scanner.findInLine(QUOTED_STRING_PATTERN);
                if (string3 == null) {
                    TimeFit.error("Missing quoted label text", n);
                }
                string3 = string3.substring(1, string3.length() - 1);
                Data data = TimeFit.getData(n4);
                data.N = d;
                data.labelText = string3;
            } else if (string2.equals("time")) {
                TimeFit.parsePlotSpecification(T_plot, scanner, n);
            } else if (string2.equals("speedup")) {
                TimeFit.parsePlotSpecification(Speedup_plot, scanner, n);
            } else if (string2.equals("eff")) {
                TimeFit.parsePlotSpecification(Eff_plot, scanner, n);
            } else if (string2.equals("edsf")) {
                TimeFit.parsePlotSpecification(EDSF_plot, scanner, n);
            } else {
                TimeFit.error("Unknown command", n);
            }
        }
    }

    private static void parsePlotSpecification(Plot plot, Scanner scanner, int n) {
        String string;
        if (!scanner.hasNext()) {
            TimeFit.error("Missing plot attribute", n);
        }
        if ((string = scanner.next()).equals("frameTitle")) {
            String string2 = scanner.findInLine(QUOTED_STRING_PATTERN);
            if (string2 == null) {
                TimeFit.error("Missing quoted frame title", n);
            }
            string2 = string2.substring(1, string2.length() - 1);
            plot.frameTitle(string2 + " (n = " + nplot + ")");
        } else if (string.equals("plotTitle")) {
            String string3 = scanner.findInLine(QUOTED_STRING_PATTERN);
            if (string3 == null) {
                TimeFit.error("Missing quoted plot title", n);
            }
            string3 = string3.substring(1, string3.length() - 1);
            plot.plotTitle(string3 + " (n = " + nplot + ")");
        } else if (string.equals("margins")) {
            if (!scanner.hasNextDouble()) {
                TimeFit.error("Missing margins value", n);
            }
            double d = scanner.nextDouble();
            plot.margins(d);
        } else if (string.equals("leftMargin")) {
            if (!scanner.hasNextDouble()) {
                TimeFit.error("Missing left margin value", n);
            }
            double d = scanner.nextDouble();
            plot.leftMargin(d);
        } else if (string.equals("topMargin")) {
            if (!scanner.hasNextDouble()) {
                TimeFit.error("Missing top margin value", n);
            }
            double d = scanner.nextDouble();
            plot.topMargin(d);
        } else if (string.equals("rightMargin")) {
            if (!scanner.hasNextDouble()) {
                TimeFit.error("Missing right margin value", n);
            }
            double d = scanner.nextDouble();
            plot.rightMargin(d);
        } else if (string.equals("bottomMargin")) {
            if (!scanner.hasNextDouble()) {
                TimeFit.error("Missing bottom margin value", n);
            }
            double d = scanner.nextDouble();
            plot.bottomMargin(d);
        } else if (string.equals("xAxisStart")) {
            if (!scanner.hasNextDouble()) {
                TimeFit.error("Missing X axis start value", n);
            }
            double d = scanner.nextDouble();
            plot.xAxisStart(d);
        } else if (string.equals("xAxisEnd")) {
            if (!scanner.hasNextDouble()) {
                TimeFit.error("Missing X axis end value", n);
            }
            double d = scanner.nextDouble();
            plot.xAxisEnd(d);
        } else if (string.equals("xAxisMajorDivisions")) {
            if (!scanner.hasNextInt()) {
                TimeFit.error("Missing X axis major divisions value", n);
            }
            int n2 = scanner.nextInt();
            plot.xAxisMajorDivisions(n2);
        } else if (string.equals("xAxisMinorDivisions")) {
            if (!scanner.hasNextInt()) {
                TimeFit.error("Missing X axis minor divisions value", n);
            }
            int n3 = scanner.nextInt();
            plot.xAxisMinorDivisions(n3);
        } else if (string.equals("xAxisLength")) {
            if (!scanner.hasNextDouble()) {
                TimeFit.error("Missing X axis length value", n);
            }
            double d = scanner.nextDouble();
            plot.xAxisLength(d);
        } else if (string.equals("xAxisTitle")) {
            String string4 = scanner.findInLine(QUOTED_STRING_PATTERN);
            if (string4 == null) {
                TimeFit.error("Missing quoted X axis title", n);
            }
            string4 = string4.substring(1, string4.length() - 1);
            plot.xAxisTitle(string4);
        } else if (string.equals("yAxisStart")) {
            if (!scanner.hasNextDouble()) {
                TimeFit.error("Missing Y axis start value", n);
            }
            double d = scanner.nextDouble();
            plot.yAxisStart(d);
        } else if (string.equals("yAxisEnd")) {
            if (!scanner.hasNextDouble()) {
                TimeFit.error("Missing Y axis end value", n);
            }
            double d = scanner.nextDouble();
            plot.yAxisEnd(d);
        } else if (string.equals("yAxisMajorDivisions")) {
            if (!scanner.hasNextInt()) {
                TimeFit.error("Missing Y axis major divisions value", n);
            }
            int n4 = scanner.nextInt();
            plot.yAxisMajorDivisions(n4);
        } else if (string.equals("yAxisMinorDivisions")) {
            if (!scanner.hasNextInt()) {
                TimeFit.error("Missing Y axis minor divisions value", n);
            }
            int n5 = scanner.nextInt();
            plot.yAxisMinorDivisions(n5);
        } else if (string.equals("yAxisTickFormat")) {
            String string5 = scanner.findInLine(QUOTED_STRING_PATTERN);
            if (string5 == null) {
                TimeFit.error("Missing quoted Y axis tick format", n);
            }
            string5 = string5.substring(1, string5.length() - 1);
            plot.yAxisTickFormat(new DecimalFormat(string5));
        } else if (string.equals("yAxisLength")) {
            if (!scanner.hasNextDouble()) {
                TimeFit.error("Missing Y axis length value", n);
            }
            double d = scanner.nextDouble();
            plot.yAxisLength(d);
        } else if (string.equals("yAxisTitle")) {
            String string6 = scanner.findInLine(QUOTED_STRING_PATTERN);
            if (string6 == null) {
                TimeFit.error("Missing quoted Y axis title", n);
            }
            string6 = string6.substring(1, string6.length() - 1);
            plot.yAxisTitle(string6);
        } else if (string.equals("yAxisTitleOffset")) {
            if (!scanner.hasNextDouble()) {
                TimeFit.error("Missing Y axis title offset value", n);
            }
            double d = scanner.nextDouble();
            plot.yAxisTitleOffset(d);
        } else {
            TimeFit.error("Unknown plot attribute", n);
        }
    }

    private static Data getData(int n) {
        Data data = dataMap.get(n);
        if (data == null) {
            data = new Data(n);
            dataMap.put(n, data);
        }
        return data;
    }

    private static void validateData(Data data) {
        if (data.K_series.isEmpty()) {
            return;
        }
        if (data.T_par_1 == 0.0) {
            System.err.println("Error: n = " + data.n + ": No data for K = 1");
            System.exit(1);
        }
        double d = Double.NEGATIVE_INFINITY;
        for (double d2 : data.K_series) {
            if (d2 <= d) {
                System.err.println("Error: n = " + data.n + ": K values not in ascending order");
                System.exit(1);
            }
            d = d2;
        }
    }

    private static double modelFunction(double d, double d2, double[] dArray) {
        double d3 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d3 += dArray[i] * basis.get(i).f(d, d2);
        }
        return d3;
    }

    private static void printData(Data data) {
        System.out.println("n\tK\tT\tSpdup\tEffic\tEDSF");
        System.out.println(data.n + "\t" + FMT_0.format(data.K_series.x(0)) + "\t" + FMT_0.format(data.T_series.x(0)) + "\t" + FMT_3.format(data.Speedup_series.x(0)) + "\t" + FMT_3.format(data.Eff_series.x(0)));
        for (int i = 1; i < data.K_series.length(); ++i) {
            System.out.println(data.n + "\t" + FMT_0.format(data.K_series.x(i)) + "\t" + FMT_0.format(data.T_series.x(i)) + "\t" + FMT_3.format(data.Speedup_series.x(i)) + "\t" + FMT_3.format(data.Eff_series.x(i)) + "\t" + FMT_3.format(data.EDSF_series_2.x(i - 1)));
        }
    }

    private static void plotData(Data data, String string) {
        int n = data.K_series.length();
        T_plot.xySeries(new AggregateXYSeries(data.K_series, data.T_series)).label(string, data.K_series.x(n - 1), data.T_series.x(n - 1));
        Speedup_plot.xySeries(new AggregateXYSeries(data.K_series, data.Speedup_series)).label(string, data.K_series.x(n - 1), data.Speedup_series.x(n - 1));
        Eff_plot.xySeries(new AggregateXYSeries(data.K_series, data.Eff_series)).label(string, data.K_series.x(n - 1), data.Eff_series.x(n - 1));
        EDSF_plot.xySeries(new AggregateXYSeries(data.K_series_2, data.EDSF_series_2)).label(string, data.K_series_2.x(n - 2), data.EDSF_series_2.x(n - 2));
    }

    private static void error(String string, int n) {
        System.err.println("Error: line " + n + ": " + string);
        System.exit(1);
    }

    private static void usage() {
        System.err.println("Usage: java TimeFit <inputfile> <nplot> <f1> [<f2> ...]");
        System.exit(1);
    }

    static {
        basis = new ArrayList();
        LOG_2 = Math.log(2.0);
    }

    private static abstract class BasisFunction {
        private BasisFunction() {
        }

        public abstract double f(double var1, double var3);

        public abstract String toString(double var1);
    }

    private static class Data {
        public int n;
        public double T_seq;
        public double T_max_seq;
        public double Dev_seq;
        public double T_par_1;
        public ListSeries K_series = new ListSeries();
        public ListSeries T_series = new ListSeries();
        public ListSeries T_max_series = new ListSeries();
        public ListSeries Speedup_series = new ListSeries();
        public ListSeries Eff_series = new ListSeries();
        public ListSeries Dev_series = new ListSeries();
        public ListSeries K_series_2 = new ListSeries();
        public ListSeries EDSF_series_2 = new ListSeries();
        public double N;
        public String labelText;

        public Data(int n) {
            this.n = n;
            this.N = n;
            this.labelText = "N = " + n;
        }
    }
}

