### R code from vignette source 'cisPath.Rnw'

###################################################
### code chunk number 1: example1
###################################################
  library(cisPath)
  sprotFile <- system.file("extdata", "uniprot_sprot_human10.dat", 
                                            package="cisPath")
  mappingFile <- file.path(tempdir(), "mappingFile.txt")
  getMappingFile(sprotFile, output=mappingFile)


###################################################
### code chunk number 2: example2
###################################################
  STRINGPPI <- file.path(tempdir(), "STRINGPPI.txt")
  fileFromSTRING <- system.file("extdata", "protein.links.txt", 
                                             package="cisPath")
  formatSTRINGPPI(fileFromSTRING, mappingFile, "9606", output=STRINGPPI, 700)


###################################################
### code chunk number 3: example3_1
###################################################
  input <- system.file("extdata", "Homo_sapiens_PINA2.sif", package="cisPath")
  PINA2PPI <- file.path(tempdir(), "PINA2PPI.txt")
  formatSIFfile(input, mappingFile, output=PINA2PPI)


###################################################
### code chunk number 4: example3_2
###################################################
  input <- system.file("extdata", "Homo_sapiens_PINA100.txt", package="cisPath")
  PINAPPI <- file.path(tempdir(), "PINAPPI.txt")
  formatPINAPPI(input, output=PINAPPI)


###################################################
### code chunk number 5: example4
###################################################
  input <- system.file("extdata", "9606.mitab.100.txt", package="cisPath")
  iRefIndex <- file.path(tempdir(), "iRefIndex.txt")
  formatiRefIndex(input, output=iRefIndex)


###################################################
### code chunk number 6: example5
###################################################
  output <- file.path(tempdir(), "allPPI.txt")
  combinePPI(c(PINA2PPI, iRefIndex, STRINGPPI), output)


###################################################
### code chunk number 7: example6
###################################################
  infoFile <- system.file("extdata", "PPI_Info.txt", package="cisPath")
  outputDir <- file.path(tempdir(), "networkView")
  networkView(infoFile, c("MAGI1","TP53BP2","TP53", "PTEN"), outputDir, 
                                   FALSE, c(1,1,1,0), displayMore=TRUE)


###################################################
### code chunk number 8: example7
###################################################
  infoFile <- system.file("extdata", "PPI_Info.txt", package="cisPath")
  outputDir <- file.path(tempdir(), "networkView2")
  inputFile <- system.file("extdata", "networkView.txt", package="cisPath")
  rt <- read.table(inputFile, sep=",", comment.char="", header=TRUE)
  proteins <- as.vector(rt[,1])
  sizes <- as.vector(rt[,2])
  colors <- as.vector(rt[,3])
  networkView(infoFile, proteins, outputDir, FALSE, sizes, colors, FALSE)


###################################################
### code chunk number 9: example8
###################################################
  infoFile <- system.file("extdata", "PPI_Info.txt", package="cisPath")
  outputDir <- file.path(tempdir(), "TP53_example1")
  results <- cisPath(infoFile, outputDir, "TP53", c("MAGI1", "GH1"), 
                                                       byStep=TRUE)


###################################################
### code chunk number 10: example9
###################################################
  infoFile <- system.file("extdata", "PPI_Info.txt", package="cisPath")
  outputDir <- file.path(tempdir(), "TP53_example2")
  results <- cisPath(infoFile, outputDir, "TP53", 
                     targetProteins=c("Q96QZ7", "P01241"), swissProtID=TRUE)
  results


###################################################
### code chunk number 11: example10
###################################################
  infoFile <- system.file("extdata", "PPI_Info.txt", package="cisPath")
  outputDir <- file.path(tempdir(), "TP53_example3")
  results <- cisPath(infoFile, outputDir, "TP53")
  results


###################################################
### code chunk number 12: example11
###################################################
  infoFile <- system.file("extdata", "PPI_Info.txt", package="cisPath")
  outputDir <- file.path(tempdir(), "cisPathResult")
  results <- cisPath(infoFile, outputDir)


###################################################
### code chunk number 13: example12 (eval = FALSE)
###################################################
##   outputDir <- "/home/user/TP53"
##   # Create the output directory
##   dir.create(outputDir, showWarnings = FALSE, recursive = TRUE)
##   # infoFile: site where the PPI data file will be saved.
##   infoFile <- file.path(outputDir, "Homo_sapiens_PPI.txt")
##   # Download PPI data
##   url <- "http://www.isb.pku.edu.cn/cispath/data/Homo_sapiens_PPI.txt"
##   download.file(url, infoFile)
##   results <- cisPath(infoFile, outputDir, "TP53", byStep=TRUE)
##   
##   outputDir <- "/home/user/cisPathWeb"
##   results <- cisPath(infoFile, outputDir)


###################################################
### code chunk number 14: example13
###################################################
  outputDir <- file.path(tempdir(), "easyEditor")
  easyEditor(outputDir)


