/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.svg.util;

public class Args {
    private Args() {
    }

    public static void nullNotPermitted(Object obj, String ref) {
        if (obj == null) {
            throw new IllegalArgumentException("Null '" + ref + "' argument.");
        }
    }

    public static void requireInRange(int value, String name, int lowerBound, int upperBound) {
        if (value < lowerBound || value > upperBound) {
            throw new IllegalArgumentException("Require '" + name + "' (" + value + ") to be in the range " + lowerBound + " to " + upperBound);
        }
    }

    public static void requireFinitePositive(double d, String ref) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("Require positive value for '" + ref + "' argument.");
        }
        if (!Double.isFinite(d)) {
            throw new IllegalArgumentException("Require finite value for '" + ref + "' argument.");
        }
    }

    public static void arrayMustHaveLength(int length, boolean[] array, String ref) {
        Args.nullNotPermitted(array, "array");
        if (array.length != length) {
            throw new IllegalArgumentException("Array '" + ref + "' requires length " + length);
        }
    }

    public static void arrayMustHaveLength(int length, double[] array, String ref) {
        Args.nullNotPermitted(array, "array");
        if (array.length != length) {
            throw new IllegalArgumentException("Array '" + ref + "' requires length " + length);
        }
    }
}

